
;;;---------------------------------------------------------------
;;;
;;;   hanoi.lisp
;;;   Leonard Dickens
;;;   7/92
;;;
;;;   This is a strips implementation of the Towers of Hanoi problem.
;;;---------------------------------------------------------------

(reset-stripsops)
(setf *debug-strips* t)

(strips-op move-disk
	   :preconditions  ( (clear ?x)
			     (on ?x ?y) 
			     (clear ?z) )
	   :filter         ( (disk ?x)
			     (smaller ?x ?z)
			     (place ?y)
			     (:not-equal ?x ?y)
			     (:not-equal ?x ?z)
			     (:not-equal ?z ?y) )
	   :add-list       ( (on ?x ?z)
			     (clear ?y) )
	   :delete-list    ( (on ?x ?y) 
			     (clear ?z) ) 
	   :command-string "move ?x from ?y to ?z"
	   :variables      (?x ?y ?z)
	   )

;;
;;    |       |      |
;;   +++      |      |
;;   |a|      |      |
;;  +---+     |      |
;;  | b |     |      |
;; +-----+    |      |
;; |  c  |    |      |
;;-+--+--+----+------+-
;;   peg1    peg2   peg3
(setq start
      '((place a)
	(place b)
	(place c)
	(place peg1)
	(place peg2)
	(place peg3)
	(disk a)
	(disk b)
	(disk c)
	(smaller c peg1)
	(smaller c peg2)
	(smaller c peg3)
	(smaller b peg1)
	(smaller b peg2)
	(smaller b peg3)
	(smaller a peg1)
	(smaller a peg2)
	(smaller a peg3)
	(smaller b c)
	(smaller a c)
	(smaller a b)
	(clear a)
	(on a b)
	(on b c)
	(on c peg1)
	(clear peg2)
	(clear peg3)))

(setq goal
      '((on a b)
	(on b c)
	(on c peg2)))

(defun test ()
  (strips start goal))
