;;;---------------------------------------------------------------
;;;
;;;   blocksworld.lisp
;;;   Leonard Dickens
;;;   7/92
;;;
;;;   This is a strips implementation of some standard blocksworld
;;;   problems.
;;;---------------------------------------------------------------

(reset-stripsops)
(setf *debug-strips* t)

(strips-op move-block-to-table
	   :preconditions  ( (clear ?x)
			     (on ?x ?y) )
	   :filter         ( (block ?x)
			     (block ?y) 
			     (:not-equal ?x ?y) )
	   :add-list       ( (on ?x table) 
			     (clear ?y) )
	   :delete-list    ( (on ?x ?y) ) 
	   :command-string "move ?x from ?y to the table"
	   :variables      (?x ?y)
	   )

(strips-op move-block-to-block
	   :filter         ( (block ?x)
			     (block ?y)
			     (block ?z) 
			     (:not-equal ?x ?y)
			     (:not-equal ?z ?y)
			     (:not-equal ?x ?z) )
	   :preconditions  ( (on ?x ?y)
			     (clear ?x) 
			     (clear ?z) )
	   :add-list       ( (on ?x ?z) 
			     (clear ?y) )
	   :delete-list    ( (on ?x ?y) 
			     (clear ?z) )
	   :command-string "move ?x from ?y to ?z"
	   :variables      (?x ?y ?z)
	   )

(strips-op move-block-from-table
	   :filter         ( (block ?x)
			     (block ?y)
			     (:not-equal ?x ?y) )
	   :preconditions  ( (on ?x table)
			     (clear ?x)
			     (clear ?y) )
	   :add-list       ( (on ?x ?y) )
	   :delete-list    ( (clear ?y) )
	   :command-string "move ?x from the table to ?y"
	   :variables      (?x ?y)
	   )


;;
;; +---+    +---+
;; | a |    | c |
;; +---+    +---+
;; | b |    | d |
;;-+---+----+---+-  <-- table
;;    
(setq ab-cd
  '((block a)
    (block b)
    (block c)
    (block d)
    (clear a)
    (on a b)
    (on b table)
    (clear c)
    (on c d)
    (on d table)))


(defun test0 ()
  (strips 
   ab-cd
   ab-cd))


(defun test1 ()
  (strips 
   ab-cd
   '((on a c) 
     (on b d))))


(defun test2 ()
  (strips 
   ab-cd
   '((on a b) 
     (on b d))))


(defun test3 ()
  (strips 
   ab-cd
   '((on b c) 
     (on c d))))


(defun test4 ()
  (strips 
   ab-cd
   '((on a c) 
     (on c d))))


(defun test5 ()
  (strips 
   ab-cd
   '((on c d)
     (on a c))))
