/* rec: receive input from other program(s) via socket, as
 *      well as possibly stdin.  All input is simply copied to stdout.
 *      
 * Leonard Dickens, 9/2/92
 */
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include "socket_server.h"

#define NULL 0

void rec_exit()
{
  socket_server_shutdown();
  exit(0);
  }


void rec_new_client(sd)
     int sd;
{
  fcntl(sd, F_SETFL, O_NONBLOCK);
  }


void rec_read_input(sd)
     int sd;
{
  int x;  
  char buffer[128];

  while (128 == (x = read(sd, buffer, 128)))
    write(1, buffer, 128);
  if (x > 0)
    write(1, buffer, x);

  if (x == 0) {
    socket_server_end_of_file(sd);
    return;
    }
  }


int main(argc, argv)
     int argc;
     char *argv[];
{
  char *socket_port = NULL;
  int x, max_clients;
  int read_stdin = 0;
  fd_set stdin_set;

  /* close all files except standards so that we can use them: */
  for (x = 3; x < 64; x++)
    close(x);

  x = 1;
  while (x < argc)
    {
    if (argv[x][0] == '-')
      switch (argv[x][1]) {
      case 'p': /* Port */
	socket_port = argv[++x];
	break;
      case 'c': /* Client limit */
	max_clients = atoi(argv[++x]);
	break;
      case 'i': /* Read stdin also */
	read_stdin = 1;
	}
    x++;
    }

  if (socket_port == NULL)
    {
    char *usage_string = "\n\
Usage: rec [-c L] [-i] -p N\n\
          -c L  means `at maximum, allow L clients to connect at once'\n\
          -p N  means `use port N for connection socket'\n\
          -i    means `read input from stdin'\n\
\n";
    write(1, usage_string, strlen(usage_string));
    exit(0);
    }

  /* catch broken pipe signals (i.e. a client process died) harmlessly. */
  signal(SIGINT,  rec_exit);
  signal(SIGTERM, rec_exit);
  signal(SIGQUIT, rec_exit);

  FD_ZERO(&stdin_set);
  if (read_stdin) {
    FD_SET(0, &stdin_set);
    fcntl(0, F_SETFL, O_NONBLOCK);
    }
  fcntl(1, F_SETFL, O_NONBLOCK);
  socket_server_initialize(rec_read_input, &stdin_set);

  if (socket_server_startup(socket_port, rec_read_input, max_clients, 
			    rec_new_client, NULL))
    return;
  socket_server_poll(NULL);
  }

