/* create and connect an internet socket for output.
 * Copyright (c) 1989,1991,1992  Leonard Dickens
 * Intelligent Data Management, NASA Goddard Space Flight Center
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
 * to anyone for the consequences of using it or for whether it serves any 
 * particular purpose or works at all.
 * 
 * You may copy, modify and generally use this software freely, as long as
 * this copyright notice is left intact in every copy or derivative work.
 */
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#undef s_addr
#include <netdb.h>
#include <signal.h>
#include <sys/file.h>

#define NULL 0

static struct sockaddr_in *init_inet_addr(addr, host_name, socket_port)
     struct sockaddr_in *addr;
     char *host_name;
     char *socket_port;
{
  struct hostent *hp;

  /* Prepare INET binding: see Sun IPC Primer p. 20 */
  if (NULL == (hp = gethostbyname(host_name)))
    {
    write(2, "\nUnknown host ", 14);
    write(2, host_name, strlen(host_name));
    return NULL;
    }
  bzero(addr, sizeof(struct sockaddr_in));
  bcopy(hp->h_addr, &(addr->sin_addr), hp->h_length);
  addr->sin_family = hp->h_addrtype;
  addr->sin_port = atoi(socket_port);
  return addr;
  }


int open_socket(host_name, port_num)
     char *host_name;
     char *port_num;
{
  struct sockaddr_in s_addr;
  struct linger linger;
  char *addr;
  int x, ntries, output_sd, len = sizeof(struct sockaddr_in);

  if (NULL == (addr = (char *) init_inet_addr(&s_addr, host_name, port_num)))
    return -1;

  ntries = 0;

  while (-1 != (output_sd = socket(AF_INET, SOCK_STREAM, 0)))
    {
    if (0 == (x = connect(output_sd, addr, len)))
      break;
    close(output_sd);
    if ((ntries++ > 6) || 
	(errno == EBADF) || (errno == EAFNOSUPPORT) || (errno == EISCONN) || 
	(errno == ENETUNREACH) || (errno == EADDRINUSE) || (errno == EFAULT))
      return -1;
    sleep(1);
    }

  linger.l_onoff = 1;
  linger.l_linger = 0;
#if 0
  setsockopt(output_sd, SOL_SOCKET, SO_LINGER, (char*)&linger);
#endif
  return output_sd;
  }

