/* Interface function for lisp to use socket server
 * Leonard Dickens  9-1-92
 */
#include <sys/time.h>
#include "socket_server.h"

#ifndef NULL
#define NULL 0
#endif

int lisp_socket_server_initialize()
{
  socket_server_initialize(0,0);
  }


int lisp_socket_server_poll(milliseconds)
     int milliseconds;
{
  struct timeval t;

  if (milliseconds < 0)
    return socket_server_poll(NULL);

  t.tv_sec = milliseconds / 1000;
  t.tv_usec = milliseconds % 1000;
  return socket_server_poll(&t);
  }


int lisp_socket_server_get_port()
{
  struct connection *x = socket_server_get_connection();
  
  if (x == NULL)
    return -1;
  return atoi(x->port);
  }
