/* Fsend: like send, but uses file io.
 */
#include "error.h"
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include "open_socket.h"

MNAME(__FILE__);

static char *host_name   = "localhost";   /* the default. */
static char *socket_port = ""; 
static FILE *socket_f = NULL;


FILE *fopen_socket(host_name, port_num)
     char *host_name;
     char *port_num;
{
  int sd = open_socket(host_name, port_num);

  if (-1 == sd)
    return NULL;
  return fdopen(sd, "w");
  }


void fsend_dead_server()
{
  printf("\nfsend: warning -- receiving socket has closed.\n");
  fclose(socket_f);
  socket_f = NULL;
  }


void fsend_shutdown()
{
  fprintf(stderr, "\nfsend: aborting.\n");
  fclose(socket_f);
  exit(0);
  }


int main(argc, argv)
     int argc;
     char *argv[];
{
  int x;
  char buffer[1];
  FNAME("main");

  /* close all files except standards so that we can use them: */
  for (x = 3; x < 32; x++)
    close(x);

  x = 1;
  while (x < argc)
    {
#if 0
    fprintf(stdout, "%s\n", argv[x]);
#endif
    if (argv[x][0] == '-')
      switch (argv[x++][1]) {
      case 'h': /* Host */
      case 'm': /* Machine */
	host_name = argv[x++];
	break;
      case 'p': /* Port */
	socket_port = argv[x++];
	break;
	}
    else x += 1;
    }

  if (socket_port[0] == '\0')
    {
    fprintf(stderr, "Usage: fsend [-h machine] -p portnum\n");
    exit(0);
    }

  if (NULL == (socket_f = fopen_socket(host_name, socket_port)))
    {
    fprintf(stderr, "fsend: unable to open socket %s to \"%s\".\n",
	    socket_port, host_name);
    exit(-1);
    }

  /* catch broken pipe signals (i.e. a client process died) harmlessly. */
  if ((-1 == (int) signal(SIGPIPE, fsend_dead_server)) || 
      /* Catch control-c for smooth termination. */
      (-1 == (int) signal(SIGINT,  fsend_shutdown))   ||
      (-1 == (int) signal(SIGTERM, fsend_shutdown))   ||
      (-1 == (int) signal(SIGQUIT, fsend_shutdown)))
    SYS_ERROR("signal", -1, 0);

  while (fread(buffer, 1, 1, stdin))
    {
    fwrite(buffer, 1, 1, stdout);
    fflush(stdout);
    if (socket_f != NULL) {
      fwrite(buffer, 1, 1, socket_f);
      fflush(socket_f);
      }
    }

  fprintf(stderr, "\nfsend: bye\n");
  }

