/* Bsend: like send, but uses buffer_io.
 */
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include "buffer_io.h"

#define NULL 0

static char *host_name   = "localhost";   /* the default. */
static char *socket_port = NULL;
static int   socket_sd = -1;

void bsend_dead_server()
{
  write(1, "\nsend: warning -- receiving socket has closed.\n", 47);
  shutdown(socket_sd);
  socket_sd = -1;
  }


void bsend_shutdown()
{
  write(1, "\nsend: aborting.\n", 17 );
  shutdown(socket_sd);
  exit(0);
  }


int main(argc, argv)
     int argc;
     char *argv[];
{
  int x;
  char buffer[1];

  /* close all files except standards so that we can use them: */
  for (x = 3; x < 32; x++)
    close(x);

  x = 1;
  while (x < argc)
    {
    if (argv[x][0] == '-')
      switch (argv[x++][1]) {
      case 'h': /* Host */
      case 'm': /* Machine */
	host_name = argv[x++];
	break;
      case 'p': /* Port */
	socket_port = argv[x++];
	break;
	}
    else x += 1;
    }

  if (socket_port == NULL)
    {
    write(1, "Usage: send [-h machine] -p portnum\n", 36);
    exit(0);
    }

  if (-1 == (socket_sd = open_socket(host_name, socket_port)))
    {
    write(1, "bsend: unable to open socket ", 28);
    write(1, socket_port, strlen(socket_port));
    write(1, " at \"", 5);
    write(1, host_name, strlen(host_name));
    write(1, "\".\n", 3);
    exit(-1);
    }

  /* catch broken pipe signals (i.e. a client process died) harmlessly. */
  signal(SIGPIPE, bsend_dead_server);
  /* Catch control-c for smooth termination. */
  signal(SIGINT,  bsend_shutdown);
  signal(SIGTERM, bsend_shutdown);
  signal(SIGQUIT, bsend_shutdown);

  while (read(0, buffer, 1))
    {
    if (x == -1)
      bsend_shutdown();
    write(1, buffer, 1);
    if (socket_sd != -1)
      write_buffer(socket_sd, buffer, 1);
    }

  write(1, "\nsend: bye\n", 11);
  }

