#|

to use the vcr code:

1.  load everything

2. (record-vcr)

3.  run the planner

3.5.  go to step 8 below if desired; to do the normal VCR go to step 4

4. (load-vcr "<identifier>")

5.  go to 3, until done

6.  (play)

7.  (stop-vcr) to stop data collection

optional:

to dipslay a textual trace of the plans leading to some particular plan:

8. :ld vcr-extra

9. (walk-from <plan-id>)

    where <plan-id> is the number of the plan to which you want a path

10. goto 2

|#

(setf *vcr-loaded* t) ;; stupid hack for "buridan.lisp"

" (c) 1992 Copyright (c) University of Washington
  Written by Tony Barrett.

  All rights reserved. Use of this software is permitted for non-commercial
  research purposes, and it may be copied only for that use.  All copies must
  include this copyright message.  This software is made available AS IS, and
  neither the authors nor the University of Washington make any warranty about
  the software or its performance.

  When you first acquire this software please send mail to
  bug-snlp@cs.washington.edu; the same address should be used for problems."

;; *
;; * modified for buridan by nick, 9 september 1992
;; *
;; the biggest change involved carrying the threshold along so that the
;; ordering code could know when the plan is complete.  but this still
;; isn't perfect, so it sometimes gets confused.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; The following code is used to implement a graphic interface to snlp
;;; that uses the clim graphics package.

;;(in-package 'snlp)

;;(export '(record play))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 1. Variables and structures

(defvar *tape* nil)			; A SNLP run trace
(defvar *recording* nil)		; Are we recording?
(defvar *display* nil)			; Where to show the movie
(defvar *window* nil)
(defvar *max-open* 1)
(defvar *max-unsafe* 1)
(defvar *max-links* 1)
(defvar *max-steps* 1)
(defvar *trees* nil)
(defvar *movie-frame* nil)
(defvar *tree-scale* 8)
    
(defstruct RECORDING
  tape)

(defstruct (plan-tree (:print-function print-plan-tree))
  entry
  reason
  parent
  (next nil)
  (prev nil)
  (children nil)
  (xpos nil)
  (ypos nil))

(clim:define-presentation-type plan-picture ())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 2. Defining the display interface

(clim::define-application-frame vcr
                          ()
  ()
  (:panes ((graph :application
                  :initial-cursor-visibility :off)
           (movie :application
                  :scroll-bars nil)
           (text :application)
           (menu :command-menu)
           (documentation :pointer-documentation)))
  (:layout ((main
             (:column 1
              (:column :rest
                (graph :rest)
                (menu :compute))
              (:column 3/10
                (:row :rest
                 (movie 1/4)
                 (text  3/4)))
              (documentation :compute)))
            )))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 3. Handy interface functions for using the program

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Start recording a tape.
(defun RECORD-VCR ()
  (setf *recording* t))

(defun STOP-VCR ()
  (setf *recording* nil))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Record a single frame of the movie.
(defun VCR-FRAME (parent reason child)
  (when *recording*
    (when (eq (car reason) :init)
      (let ((threshold (second reason)))
	(setf *tape* `(,threshold . nil))))
    (push (list parent reason child) (cdr *tape*))  ;; big changes here (nick)
    child))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Load a tape into the vcr
(defun LOAD-VCR (message)
  (setf *trees* (nconc *trees* (list (cons (compute-tree *tape*) message)))))
  
;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Load and display a tape using the clim graphics package.
(defun PLAY (&optional (display (system:getenv "DISPLAY")))
  (setf *movie-frame* nil)
  (when (null *display*)
    (setq *display* (clim::open-root-window :clx :host display)))
  (when (null *window*)
      (multiple-value-bind (left top right bottom)
          (size-vcr-frame *display* 0 0 800 600)
        (setq *window* 
	  (clim:make-application-frame 'vcr
				       :parent *display*
				       :left left :top top
				       :right right :bottom bottom))))
  (clim:run-frame-top-level *window*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 3. Commands

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  This macro is used to define command menu buttons
(defmacro DEFINE-VCR-BUTTON (name windows &body body)
  `(define-vcr-command 
       (,(intern (format nil "COM-~A-vcr" name)) :menu ,name) ()
     (let ,(mapcar #'(lambda (w)
		       `(,w (clim:get-frame-pane 
			     clim:*application-frame* (quote ,w))))
	    windows)
       ,@body)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; This command is used to make bugging a plan picture cause that
;;; plan to be displayed in the text window.
(define-vcr-command (com-display-plan) ((plan 'plan-picture))
  (display-a-plan plan)
  (when (or (plan-tree-next plan) (plan-tree-prev plan))
    (next-frame plan
		(clim:get-frame-pane clim:*application-frame* 'graph)
		(clim:get-frame-pane clim:*application-frame* 'movie))))
  
(clim:define-presentation-to-command-translator display-a-plan
    (plan-picture com-display-plan vcr)
  (object)
  `(,object))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Animate backward from the current movie position.
(define-vcr-button "<<" (movie graph)
  (loop
    (unless (and *movie-frame* (plan-tree-prev *movie-frame*) 
		 (vcr-sleep movie)) 
      (return nil))
    (next-frame (plan-tree-prev *movie-frame*) graph movie)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Move the movie one step backward.
(define-vcr-button "<" (movie graph)
  (when (and *movie-frame* (plan-tree-prev *movie-frame*))
    (next-frame (plan-tree-prev *movie-frame*) graph movie)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Move the movie one step forward.
(define-vcr-button ">" (movie graph)
  (when (and *movie-frame* (plan-tree-next *movie-frame*))
    (next-frame (plan-tree-next *movie-frame*) graph movie)))
    
;;;;;;;;;;;;;;;;;;;;;;;;
;;; Animate forward from the current movie position.
(define-vcr-button ">>" (movie graph)
  (loop
    (unless (and *movie-frame* (plan-tree-next *movie-frame*) 
		 (vcr-sleep movie)) 
      (return nil))
    (next-frame (plan-tree-next *movie-frame*) graph movie)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; blow up the tree diagram
(define-vcr-button "Enlarge" (graph movie)
  (when (car *trees*) 
    (setf *tree-scale* (/ *tree-scale* 2))
    (clim:window-clear graph)
    (clim:with-scaling (graph (/ 1 *tree-scale*))
      (draw-entry (caar *trees*) graph))
    (next-frame *movie-frame* graph movie)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; shrink the tree diagram
(define-vcr-button "Shrink" (graph movie)
  (when (car *trees*) 
    (setf *tree-scale* (* *tree-scale* 2))
    (clim:window-clear graph)
    (clim:with-scaling (graph (/ 1 *tree-scale*))
      (draw-entry (caar *trees*) graph))
    (next-frame *movie-frame* graph movie)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;

(defun tape-string (trees)
  (format nil "Tape `~A':~%=====================================~%"
	  (cdar trees)))

(define-vcr-button "RotateR" (graph movie text)
  (when *trees* 
    (clim:window-clear graph)
    (when *movie-frame*
      (setf *trees* (nconc (cdr *trees*) (list (car *trees*))))
      (setf *movie-frame* nil))
    (clim:window-clear graph)
    (clim:with-scaling (graph (/ 1 *tree-scale*))
      (draw-entry (caar *trees*) graph))
    (clim:window-clear text)
    (clim:with-text-style ('(:fix :roman :small) text)
      (clim:write-string (tape-string *trees*) text))
    (next-frame (caar *trees*) graph movie)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;
(define-vcr-button "RotateL" (graph movie text)
  (when *trees* 
    (clim:window-clear graph)
    (when *movie-frame*
      (setf *trees* (cons (car (last *trees*)) 
			  (remove (car (last *trees*)) *trees*)))
      (setf *movie-frame* nil))
    (clim:window-clear graph)
    (clim:with-scaling (graph (/ 1 *tree-scale*))
      (draw-entry (caar *trees*) graph))
    (clim:window-clear text)
    (clim:with-text-style ('(:fix :roman :small) text)
      (clim:write-string (tape-string *trees*) text))
    (next-frame (caar *trees*) graph movie)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;
(define-vcr-button "Delete" (graph movie text)
  (pop *trees*)
  (unless *trees*
    (setf *max-open* 1 *max-unsafe* 1 *max-links* 1 *max-steps* 1))
  (clim:window-clear graph)
  (clim:window-clear text)
  (setf *movie-frame* nil)
  (when *trees*
    (clim:with-scaling (graph (/ 1 *tree-scale*))
      (draw-entry (caar *trees*) graph))
    (clim:with-text-style ('(:fix :roman :small) text)
      (clim:write-string (tape-string *trees*) text))
    (next-frame (caar *trees*) graph movie)))
  
;;;;;;;;;;;;;;;;;;;;;;;;
;;; This command is used to exit the interface.
(define-vcr-button "Exit" (graph movie text)
  (clim:window-clear graph)
  (clim:window-clear movie)
  (clim:window-clear text)
  (setf *trees* nil
	*max-open* 1 *max-unsafe* 1 *max-links* 1 *max-steps* 1)
  (clim:frame-exit clim:*application-frame*))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Define  an interaction button
(clim:define-presentation-to-command-translator display-a-plan
    (plan-picture com-display-plan vcr)
  (object)
  `(,object))

(defun GRAPH-BUTTON (stream plan)
  (clim:with-output-as-presentation
      (:type 'plan-picture :object plan :stream stream :single-box t)
    (graph-plan stream plan :label (< *tree-scale* 16))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 4. plan-tree setup

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Compute the search tree from a tape
(defun COMPUTE-TREE (tape &aux (nodes nil))
  (dolist (entry (cdr tape))
    (setf *max-open*   
      (max *max-open*   (length (plan-open (caddr entry))))
      *max-unsafe* 
      (max *max-unsafe* (length (plan-unsafe (caddr entry))))
      *max-links*  
      (max *max-links*  (length (plan-links (caddr entry))))
      *max-steps*  
      (max *max-steps*  (length (plan-steps (caddr entry)))))
    (push (make-plan-tree :parent (car entry) 
			  :reason (cadr entry)
			  :entry (caddr entry))
	  nodes))
  (do* ((p nil (car n))
	(n nodes (cdr n)))
      ((null n) nil)
    (setf (plan-tree-next (car n)) (when (cdr n) (cadr n))
	  (plan-tree-prev (car n)) p))
  (do ((ns nodes (cdr ns)))
      ((null ns) nil)
    (dolist (n (cdr ns))
      (when (eq (plan-tree-parent n) (plan-tree-entry (car ns)))
	(push n (plan-tree-children (car ns))))))
  (order-tree (car nodes) (car tape))
  (tree-node-pos (car nodes) 0 0)
  (car nodes))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Order a tree so that the winning path is left justified
(defun ORDER-TREE (node threshold)
  (if (plan-test (plan-tree-entry node) threshold nil)
      ;; big changes here (nick)
      t
      (dolist (c (plan-tree-children node))
	(when (order-tree c threshold)
	  (setf (plan-tree-children node)
	    (cons c (remove c (plan-tree-children node))))
	  (return t)))))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Compute search tree node display positions.
(defun TREE-NODE-POS (node x y)
  (setf (plan-tree-xpos node) x
	(plan-tree-ypos node) y)
  (if (plan-tree-children node)
      (dolist (c (plan-tree-children node) x)
	(setf x (tree-node-pos c x (+ y 200))))
    (+ x 200)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Draw the tree.
(defun DRAW-ENTRY (p stream)
  (clim:with-translation (stream (plan-tree-xpos p) (plan-tree-ypos p))
    (graph-button stream p))
  (when (plan-tree-children p)
    (clim:draw-line* stream
		     (+ (plan-tree-xpos p) 55) (+ (plan-tree-ypos p) 160)
		     (+ (plan-tree-xpos p) 55) (+ (plan-tree-ypos p) 180))
    (clim:draw-line* stream
     (+ (plan-tree-xpos p) 55) (+ (plan-tree-ypos p) 180)
     (+ 55 (plan-tree-xpos (car (last (plan-tree-children p)))))
     (+ (plan-tree-ypos p) 180))
    (dolist (c (plan-tree-children p)) 
      (clim:draw-line* stream
		       (+ (plan-tree-xpos c) 55) (- (plan-tree-ypos c) 20)
		       (+ (plan-tree-xpos c) 55) (plan-tree-ypos c))
      (draw-entry c stream))))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Initialize the window when it is first created.
(defmethod initialize-instance :after ((frame vcr) &key)
  (let ((graph (clim:get-frame-pane frame 'graph))
	(movie (clim:get-frame-pane frame 'movie)))
    (clim:window-clear graph)
    (clim:window-clear movie)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 4. Utility functions

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  This routine is used to sleep between frames of an animation
;;;  it stops the animation if any button is pressed
(defun VCR-SLEEP (ws)
  (multiple-value-bind (gesture type)
      (clim:read-gesture :stream ws :timeout (/ 1 10))
    (declare (ignore gesture))
    (eq type :timeout)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  This routine is used to resize the vcr window.
(defun SIZE-VCR-FRAME
    (root desired-left desired-top desired-width desired-height)
  (declare (values left top right bottom))
  (multiple-value-bind (left top right bottom)
      (clim:window-inside-edges root)
    (let ((desired-right (+ desired-left desired-width))
          (desired-bottom (+ desired-top desired-height)))
      (when (> desired-right right)
        (setf desired-right right
              desired-left (max left (- desired-right desired-width))))
      (when (> desired-bottom bottom)
        (setf desired-bottom bottom
              desired-top (max top (- desired-bottom desired-height))))
      (values desired-left desired-top desired-right desired-bottom))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 5. Graphics routines

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  This routine makes a histogram grapp of a plan.  The bars stand for
;;;  # open conditions, # links, # unsafe, # steps respectively.
(defun GRAPH-PLAN (stream node &key (fill nil) (label nil) &aux plan)
  (setf plan (plan-tree-entry node))
  (flet ((draw-histo (fraction color)
	   (clim:draw-rectangle* stream 0 (* 110 (- 1 fraction)) 20 110
				 :ink color)))
    (when (not fill)
      (clim:draw-rectangle* stream 0 0 110 110 :ink clim::+background+)
      (draw-histo (/ (length (plan-open plan)) *max-open*) 
		  clim::+blue+)
      (clim:with-translation (stream 30 0)
        (draw-histo (/ (length (plan-links plan)) *max-links*) 
		    clim::+wheat+)
        (clim:with-translation (stream 30 0)
          (draw-histo (/ (length (plan-unsafe plan)) *max-unsafe*) 
		      clim::+red+)
          (clim:with-translation (stream 30 0)
            (draw-histo (/ (length (plan-steps plan)) *max-steps*) 
		        clim::+green+)))))
    (clim:draw-polygon* stream '(0 0 110 0 110 110 0 110)
			:closed t :filled fill :line-thickness 1)
    (when label
      (clim:draw-text stream (iconic-reason-label (plan-tree-reason node))
		      (clim:make-point 55 115) :align-x :center :align-y :top
		      :text-style '(:fix :roman :tiny)))))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; display the next frame in the animation
(defun NEXT-FRAME (frame graph movie)
  (clim:with-scaling (graph (/ 1 *tree-scale*))
    (when *movie-frame*
      (clim:with-translation (graph (plan-tree-xpos *movie-frame*) 
				    (plan-tree-ypos *movie-frame*))
	(graph-plan graph *movie-frame* :label (< *tree-scale* 16))))
    (setf *movie-frame* frame)
    (clim:with-translation (graph (plan-tree-xpos *movie-frame*) 
				  (plan-tree-ypos *movie-frame*))
      (graph-plan graph *movie-frame* :fill t :label (< *tree-scale* 16))))
  (multiple-value-bind (w h) (clim:window-inside-size movie)
    (clim:window-clear movie)
    (clim:with-scaling (movie (/ (min w h) 200))
      (clim:with-translation (movie 45 60)
	(graph-plan movie *movie-frame* :label t)))))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; This function prints out a single plan in the text window
(defun DISPLAY-A-PLAN (plan)
  (let ((txt (clim:get-frame-pane clim:*application-frame* 'text)))
    (clim:with-text-style ('(:fix :roman :tiny) txt)
      (clim:write-string (format nil "~a" plan) txt))))
  
;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Print out na plan tree entry
(defun PRINT-PLAN-TREE (plan &optional (stream t) depth)
  (declare (ignore depth))
  (display-plan (plan-tree-entry plan) stream)
  (format stream "~%Reason: ~a" (reason (plan-tree-reason plan)) stream)
  (format stream "~%--------------------------------~%"))

(defun iconic-reason-label (reason)
  (case (first reason)
    (:init "I")
    (:new-step "S")
    (:new-link "L")
    (:evaporated "E")
    (:demote "D")
    (:promote "P")
    (:confront "C")
    (otherwise "?")))
  
(defun reason (reason)
  (let ((arguments (cdr reason)))
    (case (first reason)
      (:unspecified
       "internal error -- unspecified reason")
      (:init
       "initial plan")
      (:new-step
       (format nil "new step for ~S: ~S from ~S"
	       (first arguments) (third arguments) (second arguments)))
      (:new-link
       (format nil "new link for ~S: ~S from ~S"
	       (first arguments) (third arguments) (second arguments)))
      (:evaporated
       (format nil "~S has evaporated" (first arguments)))
      (:demote
       (format nil "resolve ~S by demotion" (first arguments)))
      (:promote
       (format nil "resolve ~S by promotion" (first arguments)))
      (:confront
       (format nil "resolve ~S by confrontation" (first arguments)))
      (otherwise
       (format nil "internal error -- unknown reason: ~S" reason)))))
