;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Get today's date
(defun TODAY ()
  (let ((d (multiple-value-list (get-decoded-time))))
    (format nil "~a/~a ~a at ~a:~a:~a"
            (nth 4 d) (nth 3 d) (nth 5 d) (nth 2 d) (nth 1 d) (nth 0 d))))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Reset the global variables used for collecting statistics on the
;;;  planner.
(defun RESET-STAT-VARS ()
  (setf *nodes-visited* 0)
  (setf *unify-count* 0)
  (setf *compute-rank-unifies* 0)
  (setf *add-bind-count* 0)
  (setf *branch* 0)
  (setf *plans-created* 0))

;;;;;;;;;;;;;;;;;;;;;;;;
;;;  A divide routine that does not blow up on zero.
(defun div* (x y)
  (if (= y 0) (* 99999 99999 99999) (/ x y)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 5. Print functions

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Print out statistics from single run
(defun DISPLAY-STAT (s &optional (st t) ignore)
  (declare (ignore ignore))
  (format st "~%~%~a (Init = ~2a ; Goals = ~2a) => ~a (~a steps)     CPU ~9a"
          (stat-algo s) (stat-num-init s) (stat-num-goal s)
          (if (stat-complete? s) "Win " "Lose")
          (stat-plan-len s) (stat-time s))
  (format st "~%     Nodes (V = ~4a; Q = ~4a; C = ~4a)             Branch ~10a"
          (stat-visited s) (stat-q-len s) (stat-created s)
          (stat-ave-branch s))
  (format st "~%     Working Unifies: ~25a       Bindings added: ~5a~%"
          (- (stat-unify-count s) (stat-rank-unifies s))
          (stat-add-bindings s)))

(defun PRINT-STAT (s &optional (stream t) depth)
  (declare (ignore depth))
  (if *verbose* (display-stat s stream)
    (format stream "#Stats:<cpu time = ~9a>" 
	    (stat-time s))))
