;;; recursive implementation of reverse algorithm

(defun recur-assessor (plan tau)
  (declare (ignore tau))
  (assess-conjunction
   (conditions->cinstances '((nirvana)) :bhudda) nil nil nil plan))

(defstruct (cinstance
	    (:print-function cinstance-printer))
  condition
  step-id)

(defun cinstance-printer (cinstance stream depth)
  (declare (ignore depth))
  (format stream "{~S@~S}"
	  (cinstance-condition cinstance)
	  (cinstance-step-id cinstance)))

(defun assess-conjunction (cinstances links denouements visited plan)
  (cond (cinstances
	 (expand-a-cinstance cinstances links denouements visited plan))
	(links
	 (expand-a-link links denouements visited plan))
	(denouements
	 (expand-a-denouement denouements visited plan))
	(t
	 (when (> *trace* 8)
	   (format t "special case: empty conjunction -- p=1~%"))
	 1)))

(defun expand-a-cinstance (cinstances links denouements visited plan)
  (let* ((cinstance
	  (first cinstances))
	 (supporting-links
	  (get-links (cinstance-condition cinstance) (cinstance-step-id cinstance) plan))
	 (rest-cinstances
	  (rest cinstances)))
    (multiple-value-bind (adds subs)
	(disjunction->conjunction supporting-links)
      (- (apply #'+ (assess-link-conjunctions adds rest-cinstances links denouements visited plan))
	 (apply #'+ (assess-link-conjunctions subs rest-cinstances links denouements visited plan))))))

(defun assess-link-conjunctions (list-of-link-conjunctions rest-cinstances links denouements visited plan)
  (mapcar #'(lambda (link-conjunction)
	      (assess-conjunction rest-cinstances (append link-conjunction links) denouements visited plan))
	  list-of-link-conjunctions))

(defun expand-a-link (links denouements visited plan)
  (let ((link (first links)))
    (cond ((member link (plan-unsafe plan) :key #'unsafe-link :test #'same-link?)
	   (when (> *trace* 8)
	     (format t "special case: threatened link -- p=0"))
	   0)
	  (t
	   (let* ((denouement
		   (link-denouement link))
		  (safety-conditions
		   (mapcar #'openc-condition (link-underminers link)))
		  (safety-cinstances
		   (conditions->cinstances safety-conditions (link-consumer link)))
		  (indicator
		   (denouement-indicator denouement visited)))
	     (if (zerop indicator)
		 0
		 (* indicator
		    (assess-conjunction safety-cinstances (rest links) (add-den denouement denouements) (add-den denouement visited) plan))))))))

(defun denouement-indicator (denouement visited)
  ;; mutex --> 0
  ;; already visited --> 1
  ;; otherwise --> trigger prob
  (let* ((step-id
	  (denouement-step-id denouement))
	 (in-service-of-goal?
	  (eq step-id :goal))
	 (otpath
	  (denouement-otpath denouement))
	 (label
	  (otpath-label otpath))
	 (mutex-denouement-found?
	  (member-if #'(lambda (den)
			 (and (eql step-id (denouement-step-id den))
			      (not (eql label (otpath-label (denouement-otpath den))))))
		     visited)))
    (cond ((and (not in-service-of-goal?)
		mutex-denouement-found?)
	   0)
	  ((member denouement visited :test #'denouement-equalp)
	   (when in-service-of-goal?
	     (warn "hmm... a goal outcome showed up more than once: ~S, ~S"
		   denouement visited))
	   1)
	  (t
	   (when (and mutex-denouement-found? in-service-of-goal?)
	     (when (> *trace* 8)
	       (format t "special case -- goal outcomes aren't mutex")))
	   (trigger-prob (otpath-trigger otpath))))))
  
(defun expand-a-denouement (denouements visited plan)
  (let* ((denouement
	  (first denouements))
	 (step-id
	  (denouement-step-id denouement))
	 (trigger-conditions
	  (trigger-conditions (otpath-trigger (denouement-otpath denouement))))
	 (trigger-cinstances
	  (conditions->cinstances trigger-conditions step-id)))
    (assess-conjunction trigger-cinstances nil (rest denouements) visited plan)))

(defun conditions->cinstances (conditions step)
  (mapcar #'(lambda (condition)
	      (make-cinstance :condition condition  :step-id step))
	  conditions))

(defun add-den (denouement denouements)
  (if (member denouement denouements :test #'denouement-equalp)
      denouements
      (cons denouement denouements)))
