;;; parallell assessor -- run all the assessors in parallel, stop
;;; when the first one is finished.

(defun par-assessor (plan tau)
  (racehorse
   (list
    #'(lambda ()
	(recur-assessor plan tau))
    #'(lambda ()
	(dumb-assessor plan tau)))))

;; for the graphs (if we ever plot them) ew want to show the parallel
;; algorithm for the two other algoritms on the graph: complicated and
;; dumb.  sp the "real" parallel algorithm uses the slightly-better
;; recursive-complicated, but these 2 versions are just for generating
;; the graphs (ie, the preceding one is the defauly assessor while the next
;; ones are used in exp/exp.lisp).

(defun par-assessor2 (plan tau)
  (racehorse
   (list
    #'(lambda ()
	(complicated-assessor plan tau))
    #'(lambda ()
	(dumb-assessor plan tau)))))

;; for some dumb multiprocessing/engineering reason, if the faster process
;; happens to start late, then unless the running times are very long 
;; (say > 1 sec?) no good speedup occurs.  so par-assessor2 is for test18,
;; when dumb does well, and par-assessor3 is for test17, when complicated
;; does well.   yes this is a bit of a hack BUT IT IS IN NO WAY CHEATING!!

(defun par-assessor3 (plan tau)
  (racehorse
   (list
    #'(lambda ()
	(dumb-assessor plan tau))
    #'(lambda ()
	(complicated-assessor plan tau)))))

;; the actual code to do the funky parallel stuff

(eval-when (:compile-top-level :load-top-level :execute)
  (require :process))

(defun racehorse (functions)
  ;; takes a bunch of functions (each taking no arguments) and runs them
  ;; all in parallel.  this function returns whatever the one that finishes
  ;; first returns (the others are then killed off).
  (let* ((result
	  nil)
	 (processes
	  (mapcar
	   #'(lambda (function)
	       (mp:process-run-function
		"RH" #'(lambda () (setq result (funcall function)))))
	   functions)))
    (mp:process-wait "RH-Wait" #'(lambda () result))
    (mapc #'mp:process-kill processes)
    result))

