;; code to load buridan in a very stupid way.  first, set
;; '*buridan-directory*' to the appropriate value.  then, load this file, and
;;   (compile-buridan) [once ought to do it], then
;;   (load-buridan) [to actually load the code]
;; you may want to do something more clever here; for starters, check out
;; 'buridan.system', which works with Mark Kantrowitz's 'defsystem' package.

(defvar *buridan-directory*
    ".")  ;; set this as appropriate for your site

(defvar *buridan-filenames*
    '("utilities"
      "declarations"
      "open"
      "unsafe"
      "partial"
      "outcomes"
      "compl-assess"
      "dumb-assess"
      "recur-assess"
      ;; "par-assess" ;; hype, but no real substance
      ;; "bayes-assess" ;; slow and uses IDEAL
      "statistics"
      "buridan"
      ;; "vcr" ;; requires CLIM
      ))

(defun compile-buridan ()
  (mapc #'(lambda (filename)
	    (compile-file (make-pathname :name filename
					 :directory *buridan-directory*
					 :type "lisp"))
	    (load (make-pathname :name filename ;; so macros compile right!
				 :directory *buridan-directory*)))
	*buridan-filenames*))

(defun load-buridan ()
  (mapc #'(lambda (filename)
	    (load (make-pathname :name filename
				 :directory *buridan-directory*)))
	*buridan-filenames*))
