;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 1. Data Structures

(defvar *plan-id* 0)

(defstruct (PLAN
	    (:constructor make-plan*)
	    (:print-function plan-printer))
  (id (incf *plan-id*))
  steps
  links
  unsafe
  open
  linked
  ordering
  high-step)

(defstruct (STEP-TEMPLATE
	    (:print-function step-template-printer))
  action
  otpaths)

(defstruct (PLAN-STEP
	    (:print-function plan-step-printer))
  id
  template)

(defstruct (TRIGGER
	    (:print-function trigger-printer))
  conditions
  prob)


(defstruct (OTPATH
	    (:print-function otpath-printer))
  trigger
  outcomes
  (label (otpath-inc-label))) ;; used just for pretty-printing

(defstruct (LINK
	    (:print-function link-printer))
  denouement
  condition
  underminers
  consumer)

(defstruct (OPENC  ;; `open' taken by common-lisp
	    (:print-function openc-printer))
  condition
  consumer)

(defstruct (UNSAFE
	    (:print-function unsafe-printer))
  link
  threatener)

(defstruct (ORDERING
	    (:print-function ordering-printer))
  1st
  2nd)

(defstruct (DENOUEMENT
	    (:print-function denouement-printer))
  otpath
  step-id)

;; print functions for these data structures

(defun plan-printer (plan stream depth)
  (declare (ignore depth))
  (if *verbose*
      (display-plan plan stream)
      (format stream "{plan ~S: S=~S, L=~S, O=~S/~S, U=~S}"
	      (plan-id plan)
	      (- (length (plan-steps plan)) 2) ;; 0 and :goal
	      (length (plan-links plan))
	      (length (plan-open plan))
	      (length (plan-linked plan))
	      (length (plan-unsafe plan)))))

(defun step-template-printer (template stream depth)
  (declare (ignore depth))
  (format stream "{template: ~S}"
	  (step-template-action template)))

(defun plan-step-printer (plan-step stream depth)
  (declare (ignore depth))
  (format stream "{step ~S: ~S}"
	  (plan-step-id plan-step)
	  (step-template-action (plan-step-template plan-step))))

(defun trigger-printer (trigger stream depth)
  (declare (ignore depth))
  (format stream "{~:[~;~:*~{~A~},~]p=~S}"
	  (mapcar #'short-condition (trigger-conditions trigger))
	  (trigger-prob trigger)))

(defun otpath-printer (otpath stream depth)
  (declare (ignore depth))
  (if *verbose-otpaths?*
      (format stream "{~A: ~S ==> ~S}"
	      (otpath-label otpath)
	      (otpath-trigger otpath)
	      (otpath-outcomes otpath))
      (format stream "~A" (otpath-label otpath))))
  
(defun link-printer (link stream depth)
  (declare (ignore depth))
  (format stream "{~S ~@[-~S ~]=~A=> ~S via ~S}"
	  (link-producer link)
	  (link-underminers link)
	  (short-condition (link-condition link))
	  (link-consumer link)
	  (link-otpath link)))

(defun openc-printer (open stream depth)
  (declare (ignore depth))
  (format stream "{~A for ~S}"
	  (short-condition (openc-condition open))
	  (openc-consumer open)))

(defun unsafe-printer (unsafe stream depth)
  (declare (ignore depth))
  (format stream "{~S threatens ~S}"
	  (unsafe-threatener unsafe)
	  (unsafe-link unsafe)))

(defun ordering-printer (ordering stream depth)
  (declare (ignore depth))
  (format stream "{~S<~S}"
	  (ordering-1st ordering)
	  (ordering-2nd ordering)))

(defun denouement-printer (denouement stream depth)
  (declare (ignore depth))
  (format stream "{~S/~S}"
	  (denouement-step-id denouement)
	  (denouement-otpath denouement)))

(defun short-condition (condition)
  ;; take out space after 'NOT'
  (if (negated-expression? condition)
      (format nil "(NOT~S)" (de-negate-expression condition))
      (format nil "~S" condition)))

;;; global variable declarations

;;; 2. Variables

(defvar *Templates* nil)    ;; list of pairs of dummy step, bindings
(defvar *search-limit* 800) ;; max number of plans created
(defvar *trace* 0)	    ;; 5 = list Queue
                            ;; 4 = "Add Bind ..." (use function TRACE instead)
			    ;; 3 = "Unifying ..." (use function TRACE instead)
			    ;; 2 = "New Step? ..."
			    ;; 1 = "* New Step ..."
			    ;; 0 = "Plan at Current Node"
;;; Statistics related variables

(defvar *nodes-visited* 0)	   ;; Number of plans visited during the search
(defvar *plans-created* 0)	   ;; Number of plans created during the search
(defvar *branch* 0)	           ;; compute average branch factor
(defvar *verbose* nil)             ;; Print whole plan?

;;;;

;; some utility functions on these data structures

(defun link-producer (link)
  (denouement-step-id (link-denouement link)))

(defun link-otpath (link)
  (denouement-otpath (link-denouement link)))
