;
;	Plot routines for UNIX
;
;					J. Nagle
;					Version 1.7 of 4/22/87
;
;
;	This is a minimal but portable graphics output system; the
;	output is a binary file which can be read by PLOT(I).
;
;
(defvar plotstream nil)			; plot stream
;
;	plotopen  --  open plot file
;
(defun plotopen (filename)
  (when (plotclose plotstream))			; close if needed
  (setq plotstream				; open binary file
	(open	filename
		:direction :output
		:element-type 'unsigned-byte
		:if-exists :rename-and-delete)))
;
;	plotclose  --  close plot file
;
(defun plotclose nil
	(when plotstream (close plotstream))	; just close
	(setq plotstream nil))			; note closed
;
;	plotflush  --  flush plot file
;
;	Any unwritten output is written.
;
(defun plotflush nil
	(force-output plotstream))		; force output
;
;	utility functions
;
;	plotunumber  --  send 16-bit unsigned number to plot stream
;
(defun plotunumber (n)
  (setq n (floor n))		; coerce to integer
  (assert (> n -1))		; number must be in 0..65535
  (assert (< n 65536))
  (write-byte (mod n 256) plotstream)	; low byte
  (write-byte (floor n 256) plotstream)	; high byte
  )
;
;	plotuchar  --  send ASCII character to plot stream
;
(defun plotuchar (c)
	(write-byte (char-code c) plotstream))	; write the character
;
;	Plotting functions
;
(defun plotspace (xlim ylim)
	(plotuchar #\s)			; Space group
	(plotunumber 0)			; lower left corner coords
	(plotunumber 0)
	(plotunumber xlim)		; upper right corner coords
	(plotunumber ylim)
	)
;
;	plotline  --  draw a line
;
(defun plotline (x1 y1 x2 y2)
	(plotuchar #\l)			; line
	(plotunumber x1)		; start coords
	(plotunumber y1)		; end coords
	(plotunumber x2)
	(plotunumber y2))
;
;	plottext  --  plot text
;
(defun plottext (x y text)
	(plotuchar #\m)			; move
	(plotunumber x)			; to text start
	(plotunumber y)
	(plotuchar #\t)			; text
	(map nil #'plotuchar text)	; output the chars
	(plotuchar #\Newline)		; finish string
	)
;
;	ploterase  --  erase screen
;
(defun ploterase nil
	(plotuchar #\e))		; erase screen
