;
;	printplan  --  print plan in readable form
;
(defun printplan (plan)
  (map nil 
       (function
	(lambda (step)
		(unless (eq (first (third step)) 'nop)
			    (format t
				"Action: ~a ~%        [because ~a]~%"
				    (third step)
				    (second (fourth step))))))
       plan))
;
;	checkplan  --  check a plan while displaying it.
;
(defun checkplan (plan
&aux losers)
  (map nil 
       (function
	(lambda (step)
		(unless (eq (first (third step)) 'nop)
			(format t
				"Action: ~a ~%        [because ~a]~%"
				(third step)
				(second (fourth step)))
			;	Validate that only indicated blocks moved.
			(cond ((eq (first (third step)) 'move)
			       (checkmove (list (second (third step)))
					  (first step)	; BEFORE context
					  (second step)))	; AFTER context
			      ((eq (first (third step)) 'moveg)
			       (checkmove (second (third step))
					  (first step)	; BEFORE context
					  (second step)))	; AFTER context
			      (t (format t "BAD ACTION ~a in plan.~%" 
					 (third step))))
			;	Check stability of after state.
			(in-context (in-context (second step) (push-context))
				    (setq losers (checkstate))
				    (unless (eq losers t)
					  (format t 
						  "BAD STATE: ~a~%" losers))))))
       plan))
;
;	checkmove  --  did only indicated blocks move?
;	**UNFINISHED**
;
(defun checkmove (blks beforecontext aftercontext)
  (let ((beforeat (in-context beforecontext (context-lookup '(at * *))))
	(afterat (in-context aftercontext (context-lookup '(at * *)))))
       (assert beforeat)		; quiet compiler
       (assert afterat)
       (assert blks)
       ))
