;
;	BUILD  --  a blocks world
;
;	Originally by Scott Fahlman, as part of a Master's thesis
;	at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;	in 1974.
;
;	Brought back to life in 1987 by John Nagle.
;	Keyboarded from Fahlman's Conniver source, converted to Common
;	Lisp, and extended.
;
;						Version 1.3 of 3/3/87
;
;
;	Temporary support and counterweight planning.
;
(require 'builddefs "builddefs")		; prerequisite
;
;	try-temp  --  try temporary support
;
(defun try-temp (losers sg
			&aux (l losers) sgb spb lstate loss losses x stabsets 
			ssl supl spares g)
  (prog (fromcwt fromscaf)
	;
	;	fromcwt  --  gripe handler for try-cwt
	;
	(defun fromcwt (message retryable)
	       ;	If scaffolding disabled, skip it.
	       (return-from try-scaf (goal 'try-scaf (list losses) 'fromscaf)))
	;
	;	fromscaf  --  gripe handler for try-scaf
	;
	;	Whatever happened, just try next stable set, if any.
	;
	(defun fromscaf (message retryable)
	       (pop stabsets)
	       (go nextstabset))
	;
	;	Body of try-temp
	;
	nextloser
	(cond ((null l) (gripe (list 'no-temp)))
	      ((eq (caar l) 'unreadysup) 
	       (pop l)
	       (go nextloser)))
	(setq sgb (cadar l)
	      spb (caddar l)
	      loss (car (cdddar l))
	      lstate (rvalue 'context (cadr (cdddar l)))
	      losses (in-context lstate (cdr (getlosses loss)))
	      x (mapcar  
		 (function
		  (lambda (y) 
			  (cond ((eq (car y) spb) sgb) 
				(t (getsgblock (car y))))))
		 losses)
	      x  (remmems x (in-context sg (deplist x)))
	      stabsets (in-context lstate (stabsubs x loss sg)))
	nextstabset
	(cond ((null stabsets) (pop l) (go nextloser)))
	(setq ssl (car stabsets)
	       supl (in-context sg '(suplist (cons sgb (car stabsets))))
	       spares (getspares sgb spb (car stabsets) supl sg))
	(unless spares
		(pop stabsets)
		(go nextstabset))
	(csetq g (list 'try-cwt losses))
	(return-from try-temp (goal 'try-cwt (list losses) 'fromcwt))
	))
;
;	try-cwt  --  try using counterweights
;
(defun try-cwt (losses
		&aux loss cg facep shap facel nf n p intersg w cwl x)
  (when killcwt (gripe '(user-disabled try-cwt)))
  (prog (frombuild)
	;
	;	frombuild  --  gripe handler for BUILD calls
	;
	;	Just tries next set of losses.
	;
	(defun frombuild (message returnable)
	       (return-from try-cwt (try-cwt losses)))
	;
	;	Body of TRY-CWT
	;
	(loop
	 (unless l (gripe (list 'no-cwt)))
	 (setq loss (pop losses))
	 (setq b (car loss)
	       cg (getcgrav b)
	       mot (pmotion cg loss))
	 (unless (< (caddr mot) cwt-uplim) 
		 (setq facep (getfacep b)
		       shape (get b 'shape)
		       facel (get shape 'facel)
		       nf (get shape 'nf)
		       n 0)
		 ;	Iterate over faces.
		 (do ((n 0 (1+ n)))
		     ((= n nf))
		     (cond 
		      ((vzerop (vdiff (pvec facep n) '(0.0 0.0 1.0)))
		       (unless (setq p (pierce facep
					       facel
					       n
					       cg
					       '(0.0 0.0 1.0)))
			       (return)) ; escape face loop, try next block
		       ;
		       ;	Found a usable face.
		       ;
		       (setq w (getforce p loss '(0.0 0.0 -1.0)))
		       (unless (setq cwl (findtower-w w spares))
			       (return))	; try next block, not face.
		       ;	Build indicated counterweight tower.
		       (setq intersg (push-context sg))
		       (in-context intersg
				   (mapc 
				    (function
				     (lambda (y) (or (eq y sgb)
						     (member y ssl)
						     (member y supl)
						     (remblock y)))))
				   (getobs))
		       (in-context intersg
				   (reladd (attranslate orgloc p)
					   cwl))
		       (setq plan (goal 'build (list intersg nil) 'frombuild))
		       (setq context (cadar plan))
		       (remall '(in-place * *))
		       (protectobs sg)
		       (return-from try-cwt plan))
		      ;	This face failed, try next face or loss.
		      (t nil)))))))
  
;
;	try-scaf  --  try using spare blocks to build scaffold.
;
(defun try-scaf (losses
		 &aux (l losses) loss verts vertl facep facel
		 shape nv n v p b
		 x  intersg lp)
  (prog (frombuild)
	;
	;	Gripe handler for BUILD call
	;
	(defun frombuild (message retryable)
	       (incf n)
	       (go nextpoint))
	nextloss
	(unless l (gripe (list 'no-scaf)))
	(setq context lstate
	      loss (car l)
	      b (car loss)
	      shape (get b 'shape)
	      verts (getverts b)
	      vertl (get shape 'vertl)
	      facep (getfacep b)
	      facel (get shape 'facel)
	      nv (get shape 'nv)
	      n 0)
	nextpoint
	(when (= n nv) 
	      (pop l) 
	      (go nextloss))
	;	Unless at least one of the following four criteria hold,
	;	skip this point.
	;	***QUESTIONABLE***
	(unless
	 (or (not (outmoving vertl
			     n
			     facep
			     (setq v (pmotion (setq p
						    (pvec verts
							  n))
					      loss))))
	     (> (caddr v) scaf-downlim)
	     (covered b p)
	     (loweradj verts vertl i))
	 (incf n)
	 (go nextpoint))
	;	Construct goal state including scaffold.
	(setq context (setq intersg (push-context sg)))
	(mapc (function (lambda (y) (or (eq y sgb)
					(member y ssl)
					(member y supl)
					(remblock y))))
	      (getobs))
	(cond ((null (setq x (obbelow p)))
	       (setq lp (piercepoint (getfacep 'table)
				     0.
				     p
				     '(0.0 0.0 -1.0))))
	      ((eq x 'lose) 
	       (incf n) 
	       (go nextpoint))
	      ((setq lp x)))
	(cond ((null (setq x (findtower-h 0.0
					  (- (caddr p) (caddr lp))
					  spares)))
	       (incf n)
	       (go nextpoint)))
	(reladd (attranslate orgloc lp) x)
	(setq context oldcon )
	;	Subgoal: build scaffold.
	(setq plan (goal 'build (list intersg nil) 'frombuild))
	(setq context (cadar plan))		; accept new plan
	(remall '(in-place * *))		; scaffold is temporary.
	(protectobs sg)
	(return-from try-scaf plan)		; done
	))
