;
;	BUILD  --  a blocks world
;
;	Originally by Scott Fahlman, as part of a Master's thesis
;	at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;	in 1974.
;
;	Brought back to life in 1987 by John Nagle.
;	Keyboarded from Fahlman's Conniver source, converted to Common
;	Lisp, and extended.
;
;						Version 1.11 of 3/24/87
;
(require 'builddefs "builddefs")			; prerequisite
;
;	unbuild  --  uses build backwards to get all members of L on table.
;
;	This is a choice function.
;
(defun unbuild (l sg
		  &aux y unplan 
		  (plan plan)
		  (startplan plan) (startcontext context))
  (gripehandlers
   ;
   ;	Gripe handlers
   ;
   ((build-by-unbuild (message returnable)
		      (pass message)))		; just pass upwards.
   ;
   ;	Body of UNBUILD.
   ;
   ;	Generate a start state with blocks in storage places.
   (setq context (push-context))		
   ;	First remove all blocks in L from working state.
   (map nil (function (lambda (x) (remblock x))) l)
   ;	Add all blocks to working state using findspace.
   (map nil 
	(function 
	 (lambda (x)
		 (setq y (findspace x nil (list sg)))
		 (unless y
			 (gripe (list 'no-space-unbuild l)))
		 (addat x y)))
	l)
   ;	Our current state is now the start state.
   ;	Our goal state will be the context at entry.
   ;	Construct a BUILD request.
   (setq plan nil)			; no previous plan now
   (setq unplan (goal 'build (list startcontext) build-by-unbuild))
   ;	Restore state as if no work done.  We only want unplan.
   (setq context startcontext)	; original context
   (setq plan startplan)		; original plan
   ;	Patch final context into returned unbuilding plan.
   ;	This will be the initial context after reversal.
   (setf (second (first unplan)) startcontext) ; set new final context
   (setq plan (append (revplan unplan) plan)) ; add new section
   (setq context (second (first plan)))	; accept final context
   (remall '(in-place * *))		; remove IN-PLACE markers.
   (protectobs sg))			; protect blocks that match goal
  plan)					; finally return plan
;
;	revplan  --  reverse steps of a plan
;
;	A plan, remember, is a list of items of the form
;
;	(before-context after-context step reason))
;
(defun revplan (l &aux action)
  (reverse
   (mapcar
    (function
     (lambda (step) 
	     (setq action (third step))		; get plan action
	     ;	Construct new plan step.
	     (list (second step)	; interchange before/after contexts.
		   (first step)
		   (cond ((eq (first action) 'move) ; MOVE primitive
			  (list 'move
				(second action)
				(fourth action)	; swap before/after locs
				(third action)))
			 ((eq (first action) 'moveg); MOVEG primitive
			  (list 'moveg
				(second action)
				(third action)
				(fifth action)	; swap before/after locs
				(fourth action)))
			 ((eq (first action) 'nop)	; NO OPERATION
			  (list 'nop))		; nothing to swap
			 (t (error "Unknown primitive ~a in plan ~a"
				   (first action) l))) ; unknown
		   (fourth step))))			; same reason
    l)))
