;
;	BUILD  --  a blocks world
;
;	Originally by Scott Fahlman, as part of a Master's thesis
;	at MIT in 1973.	Described in AI	Journal, Vol 5,	pp 1ff,
;	in 1974.
;
;	Brought back to life in 1987 by John Nagle.
;	Keyboarded from Fahlman's Conniver source, converted to Common
;	Lisp, and extended.
;
;						Version 1.24 of 5/19/87
;
;	build  --  build something
;
;	
;
(require 'builddefs "builddefs")
(require 'database "database")
(require 'plandefs "plandefs")
(use-package 'builddefs)
(use-package 'database)
;
;	build  --  build something
;
;	BUILD is top-level entry - SG is desired state.
;
(defun build (sg &optional (clear t)
		 &aux blockstoplace blockstoclear trouble x z (ourplan plan))
  ;
  ;	Gripe handlers.  These are local functions with access to the
  ;			 current instance of BUILD.
  ;
  (gripehandlers
   ;
   ;	place-by-build  --  gripe handler for PLACE request.
   ;
   ((place-by-build (message returnable)
		    (cond ((eq (first message) 'unstab-add); became unstable?
			   ;	Must be complaining about current block
			   (assert (eq (first blockstoplace) (second message)))
			   (push (list 'unstab-add	; save instability
				       (first blockstoplace) ; ???BAD
				       (second message)
				       (third message)
				       nil)		; *** was backtag
				 trouble)
			   (tracks "Abandoning PLACE of ~a." (first blockstoplace))
			   (pop blockstoplace)	; try a differnt block
			   (go loop2))		; unwind and retry
			  ((eq (first message) 'hit)	; hit obstacle?
			   ;	Recover only if returnable.
			   (unless returnable (pass message))
			   ; Get rid of all colliding blocks.
			   ; We are attempting to revise a failed plan without
			   ; redoing everything since the last successful subgoal.
			   ; ***TEMP*** just doing ordinary prepgoal.
			   (mapc 
			    (function 
			     (lambda (z)
				     ; If block hasn't moved yet, move it.
				     (when (eq (cdr z) (getat (car z)))
					   (setq plan
						 (prepgoal 
						  (list 'place (first blockstoplace))
						  'get-rid-of
						  (list (car z)
							(list sg))
						  get-rid-of-recovery))
					   ;	Accept new plan and context.
					   (setq context (cadar plan)))))
			    ;	Make list ((block . loc) (block . loc) ...)
			    (mapcar 
			     (function
			      (lambda (b) (cons b (getat b))))
			     (third message)))
			   ; Gripe successfully dealt with.
			   ; Gripe handler will return.
			   ; State has changed, and griper must deal with this.
			   (return-from place-by-build plan))
			  ; Unknown gripe, pass upwards.
			  ((pass message returnable))))
    ;
    ;    get-rid-of-recovery -- handler for PLACE recovery via GET-RID-OF 
    ;
    (get-rid-of-recovery (message returnable)
			 (setq message (list 'obj-in-way-of (first blockstoplace) message))
			 (pass message))		; regripe upward
    ;
    ;	get-rid-of-by-build  --  gripe handler for GET-RID-OF
    ;
    (get-rid-of-by-build (message returnable)
			 (setq message (list 'intruding-obj 
					     (first blockstoplace) 
					     message))
			 (pass message))		; regripe upward
    ;
    ;	trymsa-by-build  --  recover from TRY-MSA failure
    ;
    (trymsa-by-build (message returnable)
		     ;	Try temporary support
		     (setq ourplan 
			   (goal 'try-temp (list trouble sg) trytemp-by-build))	
		     (go loop1))		; break out of gripe handler
    ;
    ;	trytemp-by-build  --  temporary support attempt failure
    ;
    (trytemp-by-build (message returnable)
		      (gripe (list 'build-gives-up trouble)))); actually fatal
   ;
   ;	BUILD function body.
   ;	Preliminary checks; not retryable.
   (assert (eq context (second (first ourplan))))	; plan in sync?
   (when showinter
	 (showcontext context "BUILD start state")
	 (showcontext sg "BUILD goal state"))
   ;	Make sure that current state is stable.
   (unless (eq t (setq x (checkstate)))
	   (gripe (list 'bad-sp x)))
   ;	Make sure that desired final state is stable.
   (unless (eq t
	       (setq x (in-context sg (checkstate))))
	   (gripe (list 'bad-sg x)))
   ;	Make sure that there is some matching block in current state
   ;	for all blocks in goal state.
   (when (setq x (unmatchable sg))
	 (gripe (list 'unmatchable x)))
   ;	Done validating request, now try doing it
   (setq context (push-context))	; get scratch state
   (remall '(in-place * *))	; remove all placed markers
   (protectobs sg)		; prevent move of placed blocks
   ;	Get rid of any unplaced blocks not in goal state.
   loop1
   (setq context (second (first ourplan))) ; accept new context
   (setq plan ourplan)			; accept new plan
   (setq blockstoplace (unplaced sg))	; get blocks to be placed
   (setq trouble nil)
   (when (and (null blockstoplace)
	      clear 
	      (setq blockstoclear (intruding sg)))
	 (tracks "Build: trying to get rid of ~a." blockstoclear)
	 ; All blocks placed; get rid of intruding blocks.
	 (setq trouble nil)
	 ;	Subgoal: get-rid-of block.
	 (setq ourplan (goal 'get-rid-of (list 
					  (first blockstoclear) 
					  (list sg) 
					  t)
			     get-rid-of-by-build))	
	 (go loop1))			; and try again
   ;	Put blocks where they are supposed to go.
   loop2
   (tracks "Build: trying to place ~a." blockstoplace)
   (cond ((null blockstoplace))		; no more, handle trouble.
	 ((setq z (unreadysup (first blockstoplace) sg))
	  (push (list 'unreadysup (first blockstoplace) z) trouble) ; save
	  (pop blockstoplace)		; on to next block
	  (go loop2))
	 ;		Subgoal: place block.
	 (t
	  (setq ourplan (goal 'place (list (first blockstoplace) sg)
			      place-by-build));
	  (go loop1)))			; take first of unwanted blocks.
   (assert (null blockstoplace))		; tried everything
   (unless trouble (return-from build ourplan)) ; probably done
   (tracks "Build: hard cases: ~a." trouble)
   ;	Simple approach didn't work.
   ;	Try multiple support assemblies (MSAs) if needed.
   (unless killmsa (trymsa-by-build '(msa-feature-disabled) nil))
   ;	Subgoal: MSA approach.
   (setq ourplan (goal 'try-msa (list trouble sg) trymsa-by-build))
   (setq context (cadar plan))		; success: accept new context.
   (setq plan ourplan)			; accept new plan
   (go loop1)))
;
;	unmatchable  --  get list of blocks in SG that have no matches
;			 in SP.
;
(defun unmatchable (sg)
  (prog (losers goalobs presobs)
	(setq losers nil 
	      goalobs (in-context sg (getobs))
	      presobs (getobs))
	(mapc (function
	       (lambda (x)
		       (prog (l)
			     (setq l presobs)
			     (cond ((match x (car l))
				    (setq presobs (cdr presobs))
				    (return nil)))
			     loop (cond ((null (cdr l))
					 (setq losers (cons x losers))
					 (return nil))
					((match x (cadr l))
					 (rplacd l (cddr l))
					 (return nil)))
			     (setq l (cdr l))
			     (go loop))))
	      goalobs)
	(return losers)))
;
;	protectobs  --  note in database of goal all objects in place already.
;
;	Generates IN-PLACE database items.
;
;	The algorithm is N**2 time on the total number of blocks.
;
(defun protectobs (sg
		   &aux (obs (getobs)) 
		   (goalobs (in-context (getobs))))
  (do ((i obs (cdr i)))
      ((endp i))
      (do ((j goalobs (cdr j)))
	  ((endp j))
	  (and (matchpos (car i)
			 context
			 (car j)
			 sg
			 orgloc)
	       (or (eq (car i) (car j))
		   (not (or (memq (car i) goalobs)
			    (memq (car j) obs))))
	       (context-add (list 'in-place (car i) (car j)))))))
;
;	unplaced  --  list all unplaced blocks in SG
;
;	This actually gives us a list of all blocks in SG which do not yet
;	have a matching block in the current context.
;
;	The algorithm is inefficient.
;
(defun unplaced (sg &aux l)
	      (mapc 
	       (function 
		(lambda (x)
			(unless (isimmovable x)
				; ***LINE MISSING IN ORIGINAL LISTING***
				; Look up in WORKING context.
				(unless (present (list 'in-place '* x))
					(push x l)))))
	       (in-context sg (getobs)))
  l)
;
;	intruding  --  list all unplaced blocks touching in-place blocks.
;
;	Again, the algorithm is inefficient.  This business of iterating
;	through all the blocks with a database query for each is bad.
;	It would be better to get all matchers from the database and
;	all blocks and do a set difference.
;
(defun intruding (sg &aux l)
  (mapc 
   (function 
    (lambda (x)
	    (when (and (not (present (list 'in-place x '*))) ; not in place
		       (not (isimmovable x))	; movable
		       (not (untruding x)))	; not untruding
		  (push x l))))			; this one intrudes.
   (getobs))					; over all blocks
  l)
;
;	untruding  --  true if not touching any placed block.
;
;         
(defun untruding (x 
		  &aux (l (gettouch x)))
  (when (eq (car l) 'hit)		; X should not hit anything.
	(error "Untruding: ~a hit ~a." x (cdr hit)))
  ;	Is any touching block in final place?  If so, return nil.
  (in-context sg
	      (mapc
	       (function       
		(lambda (touchentry)
			(cond ((eq (car touchentry) table))	; Table OK
			      ((present (list 'in-place (car touchentry) '*))
			       (return-from untruding nil)))))
	       l))
  t)
;
;	unreadysup  --  see if all supports of B are in place
;
(defun unreadysup (b sg
		     &aux neededsups)
  ;	Examine all supports of B in SG.  Keep if not placed.
  (mapc
   (function
    (lambda (sup)
	    (unless (isimmovable sup)
		    (unless (present (list 'in-place '* sup))
			    (push sup neededsups)))))
   (in-context sg (getsupsof b)))	; get supports of B in SG.
  neededsups)
