;
;	Dummy routines to emulate parts of BUILD not yet implemented.
;
;					J. Nagle
;					Version 1.38 of 5/19/87
;
;
;
(require 'builddefs "builddefs")
(require 'database "database")
(use-package 'builddefs)
(use-package 'database)
;
;	Clear all non-useful items from database by moving every block.
;
(defun moveall nil
	(map nil #'touchall (getobs)))
(defun touchall (b)
	(moveblock b 0 0 0))		; no-op, but clears relations
;
;	More useful user-level interface
;
(defun gen (blk shape s1 s2 s3)
	(genblock blk shape s1 s2 s3))
(defun mv (blk x y z &optional (r1 0.0) (r2 0.0) (r3 0.0))
	(moveblock blk x y z r1 r2 r3))
(defun add (blk x y z)
	(addblock blk x y z))
;
;	Situation save
;
;
;	savecontexts  --  save indicated named contexts
;
(defun savecontexts (filename &rest contexts
			      &aux (done (list table)))
  (let ((contexts (if contexts contexts all-named-contexts))) ; default to all
       (format t "Saving contexts ~a to ~a.~%" contexts filename)
       (with-open-file
	(out filename :direction :output) ; open
	;	Collect the names of all relevant blocks.
	(dolist (cntxt contexts)
		(in-context
		 cntxt
		 (dolist (b (getobs))
			 (unless (member b done)
				 ;	Output block shape info
				 (format out
					 "(genblock '~a '~a ~,4f ~,4f ~,4f)~%"
					 (block-name b) (block-shape b)
					 (aref (block-size b) 0)
					 (aref (block-size b) 1)
					 (aref (block-size b) 2))
				 (push b done)))))
	;	Output the positions in the contexts
	(dolist (cntxt contexts)
		(in-context cntxt 
			    (savesituation out))))))
;
;	savesituation  --  save single context.
;
(defun savesituation (out
 &aux allblocks blk blocks)
  (format out "(in-context empty-context (setq context (push-context))~%")
  (let ((nameitem (present '(context-name *)))) ; does it have a name?
       (when nameitem
	     (format out "(setq ~a context)~%" (second nameitem))
	     (format out "(name-context '~a)~%" (second nameitem))))
  (setq blocks (context-lookup '(at * *)))	; get blocks
  (map nil (function 
	    (lambda (item)
		    (setq blk (second item))	; get block
		    (unless (eq blk table)	; omit table
			    (format out "    (addatloc '~a ~a)~%"
				    (block-name blk)
				    (getat blk)))))
       (reverse blocks))
  (format out ")~%"))				; close in-context.
;
;	name-context  --  give a context a name
;	
;	Used for saving and reloading contexts later.
;
(defvar all-named-contexts nil "All contexts with names")
(defun name-context (name)
  (unless (member context all-named-contexts)
	  (push context all-named-contexts))
  (context-add (list 'context-name name)))
;
;	new-named-context  --  start a new named context
;
(defun new-named-context (name &optional (from empty-context))
   (setq context (in-context from (push-context))) ; new context
   (name-context name))			; name it
;
;	Dummies for unimplemented sections
;
(defun try-msa (losses sg)
	(gripe (list "TRY-MSA unimplemented")))
(defun try-temp (losers sg)
	(gripe (list "TRY-TEMP unimplemented")))
;
;	goaway  --  put block in findspace location
;
(defun goaway (b &aux where)
  (when (eq b table) (return-from goaway nil)) ; ignore table
  (setq where (findspace b))		; find space
  (unless where (error "Can't find a place to put ~a" b))
  (remblock b)
  (addat b where))
;
;	goawayall  -- get rid of all blocks
;
;	Generates a state in which all blocks are put away.
;
(defun goawayall (c)
  (in-context c
	      (in-context (push-context)
			  (map nil #'goaway (getobs))
			  context)))
;
;	Load any other temporary portions of the system.
;
(require 'robottest "robottest")
