;
;	BUILD II, by John Nagle
;
;	Database primitives
;
;	***TEMPORARY VERSION  --  LINEAR SEARCH***
;
;					Version 1.22 of 4/21/87
;
;	The database is a tree of relational databases.
;	This is a feature of CONNIVER reimplemented here.
;	This implementation is very inefficient; there is a copy of
;	the entire database in every layer and search is linear.
;	A REIMPLEMENTATION IS NEEDED.
;
(provide 'database)			; provides database
(in-package 'database)
(export '(
	  context
	  in-context
	  present
	  context-lookup
	  context-add
	  context-delete
	  remall
	  new-context
	  push-context
	  dget+
	  dput+
	  ))
;
;	layer structure  -- one for each context.
;
(defstruct (layer (:print-function context-print))
	(items)				; items in database
	(serial :read-only))		; layer serial for debug
(defvar serialnumber 0)			; serialize contexts for debug
(defvar context)			; The current context - global
(defvar dget-database (make-hash-table :test #'equal :size 100))
(defvar key nil)			; special
;
;	in-context  --  execute code in specified context
;
(defmacro in-context (con &body body)
	`(let ((context ,con)) ,@body))
;
;	present-compare  --  compare routine for PRESENT.
;
;	'* is interpreted as matching anything.
;
(defun present-compare (l &aux (key key))
  (loop
   (cond ((and (endp key) (endp l)) (return t)) ; match
	 ((or (endp key) (endp l)) (return nil)) ; mismatch
	 ((equal (car key) (car l))) ; equal, advance
	 ((eq (car key) '*))	; wild card, advance
	 ((eq (car l) '*))	; wild card, advance
	 (t (return nil)))		; end, advance
   (setq key (cdr key))		; advance l1
   (setq l (cdr l))		; advance l2
   ))
;
;	present  --  return relation if present
;
;	The key is a list; elements of '* in the list match anything.
;
(defun present (key)
	(car (member-if #'present-compare (layer-items context)))
	)
;	
;	context-lookup  --  return all matching relations
;
(defun context-lookup (key)
  (mapcan (function (lambda (item)
			    (if (present-compare item) ; if match
				(list item)		; add to list
				nil)))		; otherwise nothing
	  (layer-items context)))
;
;	context-add  --  add relation to database
;
(defun context-add (relation)
  (setf (layer-items context)
	(adjoin relation (layer-items context)))
  t)
;
;	context-delete  --  delete relation from database
;
;	An exact match is required, and it must be found.
;
(defun context-delete (relation)
  (remhash relation dget-database)	; remove any dget entries
  (setf (layer-items  context)
	(remove relation (layer-items context))))
;
;	remall  --  remove all instances of pattern from database.
;
(defun remall (pattern)
  (map nil
       (function 
	(lambda (item)
		(context-delete item))); delete item
       (context-lookup pattern)))	; get list of matching items.
;
;	new-context  --  create an empty context
;
;	Does NOT change the current context.
;
(defun new-context nil
  (make-layer 
   :serial (incf serialnumber)	; serialize for debug
   :items nil))		; no items
;
;	push-context  --  create new context that is a copy of the old.
;
;	Does NOT change the current context.
;
(defun push-context nil
  (make-layer
   :serial (incf serialnumber)	; serialize for debug
   :items (copy-list (layer-items context)))) ; copy old items
;
;	context-print  --  print a context
;
;	We just print the serial number of the context; contexts are huge.
;
(defun context-print (lay stream depth)
	(declare (ignore depth))	; not used
	(format stream "<context ~a>" (layer-serial lay)))
;
;	dget+  --  get item tagged to relation
;
;	returns (relation value tag) or nil.
;
(defun dget+ (relation tag &aux taglist elt)
  (setq taglist (gethash (list relation tag) dget-database)) ; find taglist
  (setq elt (assoc tag taglist))		; look up tag
  (if elt (list relation (cdr elt) tag)		; find
	  nil))					; fail
;
;	dput+  --  set item tagged to relation
;
(defun dput+ (relation value tag &aux taglist)
  (setq taglist (gethash (list relation tag) dget-database)) ; find taglist
  (setf (gethash (list relation tag) dget-database) (acons tag value taglist))
  t)
;
;	Initialization
;
(setq context (new-context))			; start with an empty context.
