;
;	BUILD shape definitions
;
;					Version 1.25 of 5/11/87
;
;	We actually update the database during the loading of this file,
;	which requires that other objects be present before this is loaded
;	or compiled.
;
;	
(require 'database "database")
(use-package 'database)
(require 'builddefs "builddefs")
(use-package 'builddefs)
(require 'vector "vector")
(use-package 'vector)
(require 'buildutil "buildutil")
(use-package 'buildutil)
(require 'collision "build5")
(use-package 'collision)
(require 'addblock "build3")
;
;	mkv3  --  short form of make-vector3
;
;	Not just an abbreviation, this function is needed because
;	MAKE-VECTOR3 is in a package and cannot be used directly in an
;	EVAL.
;
(defun mkv3 (x y z) (make-vector3 x y z))
;
;	mkp3  --  short form of make-plane
;
(defun mkp3 (x y z d) (make-plane :x x :y y :z z :distance d))
;
;	Initialize the origin.
;
(setq orgloc (make-location :x 0.0 :y 0.0 :z 0.0))	
;
;	Wedge
;
;	Parameterized vertices of wedge; these are expressions for later EVAL.
;
(putprop 'wedge
  '((mkv3
     (half (aref size 0)) (half (aref size 1)) (half (aref size 2)))
    (mkv3
     (half (aref size 0)) (half (aref size 1)) (- (half (aref size 2))))
    (mkv3
     (half (aref size 0)) (- (half (aref size 1))) (- (half (aref size 2))))
    (mkv3
     (half (aref size 0)) (- (half (aref size 1))) (half (aref size 2)))
    (mkv3
     (- (half (aref size 0))) (- (half (aref size 1))) (half (aref size 2)))
    (mkv3
     (- (half (aref size 0))) (- (half (aref size 1))) (- (half (aref size 2)))))
  'shape-vertices)
;	Edges of wedge; array of pairs of vertex numbers.
(putprop 'wedge
  (fillarray '(9 2)
	     '(
	       0 1
	       1 2
	       2 3
	       3 0
	       2 5
	       3 4
	       1 5
	       0 4
	       4 5))
  'shape-edges)
;	Weight (actually mass)	Expression to be evaluated.
(putprop 'wedge
  '(* 4.0
     (half (aref size 0))
     (half (aref size 1))
     (half (aref size 2)))
  'shape-weight)
;	Center of gravity.	Expression to be evaluated.
(putprop 'wedge
  '(mkv3
    (* 0.41399998 (half (aref size 0)))
    (* -0.41399998 (half (aref size 1)))
    0.0)
  'shape-cgrav)

(putprop 'wedge 'bwmatch 'shape-match-function); specify matching function

(putprop 'wedge 'fpos 'shape-findpos-function)

(putprop 'wedge 'wedge 'shape-name)
;
;		Brick 
;
(putprop 'brick
  '(
    (mkv3
     (half (aref size 0)) (half (aref size 1)) (half (aref size 2)))
    (mkv3
     (half (aref size 0)) (half (aref size 1)) (- (half (aref size 2))))
    (mkv3
     (half (aref size 0)) (- (half (aref size 1))) (- (half (aref size 2))))
    (mkv3
     (half (aref size 0)) (- (half (aref size 1))) (half (aref size 2)))
    (mkv3
     (- (half (aref size 0))) (half (aref size 1)) (half (aref size 2)))
    (mkv3
     (- (half (aref size 0))) (half (aref size 1)) (- (half (aref size 2))))
    (mkv3
     (- (half (aref size 0))) (- (half (aref size 1))) (- (half (aref size 2))))
    (mkv3
     (- (half (aref size 0))) (- (half (aref size 1))) (half (aref size 2))))
  'shape-vertices)

(putprop 'brick
  (fillarray '(12 2)
	     '(
	       0 1
	       1 2
	       2 3
	       3 0
	       4 5
	       5 6
	       6 7
	       7 4
	       0 4
	       1 5
	       2 6
	       3 7))
  'shape-edges)


(putprop 'brick 
  '(* (aref size 0) (aref size 1) (aref size 2))
  'shape-weight)

(putprop 'brick '(mkv3 0.0 0.0 0.0) 'shape-cgrav)

(putprop 'brick 'bwmatch 'shape-match-function)

(putprop 'brick 'fpos 'shape-findpos-function)

(putprop 'brick 'brick 'shape-name)
;
;	Shape of the "table"
;
(putprop 'table-shape 'table-shape 'shape-name)

(putprop 'table-shape 
  '(
    (mkv3 xmin ymin zmin)
    (mkv3 xmin ymax zmin)
    (mkv3 xmax ymax zmin)
    (mkv3 xmax ymin zmin))
  'shape-vertices)

(putprop 'table-shape
  '((mkp3  0.0  0.0  1.0  0.0))
  'shape-faceplanes)
  
(putprop 'table-shape
  (fillarray '(4 2)
	     '(
	       0 1
	       1 2
	       2 3
	       3 0))
  'shape-edges)

(putprop 'table-shape
  (fillarray '(4 2)
	     '(
	       0 0 
	       0 0
	       0 0
	       0 0))
  'shape-edgefaces)
  
(putprop 'table-shape
  (fillarray '(1 3)
	     '((0 1 2 3) (0 0 0 0) (3 0 1 2)))
  'shape-faceinfo)
  
(putprop 'table-shape
  (fillarray '(4 3)
	     '((3 1) (0 0) (3 0) (0 2) (0 0)
	       (0 1) (1 3) (0 0) (1 2) (2 0)
	       (0 0) (2 3)))
  'shape-vertex-edges)
;
;	table-shape matching function
;
;	There is only one table and it always matches itself.
;
(putprop 'table-shape 
  #'(lambda (b1 b2) 
	    (assert (eq b1 b2))			; had better match
	    t) 
  'shape-match-function)

(putprop 'table-shape
  '(mkv3 (half (+ xmin xmax)) (half (+ ymin ymax)) -1.0E+10)
  'shape-cgrav)

(putprop 'table-shape
	(max (- xmax xmin) (- ymax ymin))
	'shape-maxd)

(putprop 'table-shape
	1.0E+6
	'shape-weight)			; arbitrary weight
;
;	The table itself  --  our one built-in block.
;
(setq table (gentable 'table 'table-shape))

(setf (block-isimmovable table) t)	; mark as immovable

(addat table orgloc)			; add table at origin
