;
;      BUILD display routines
;
;					Version 1.24 of 4/26/87
;
(require 'builddefs "builddefs")
(require 'database "database")
(require 'vector "vector")
(use-package 'builddefs)
(use-package 'database)
(use-package 'vector)
;
;      Usual viewpoint for display routines
;
(defparameter vp 
  (list '*viewpoint					; 1
	(make-location :x 500.0 :y -1000.0 :z 500.0)	; 2 viewpoint
	1000.0						; 3
	t						; 4 enable perspective
	'(0.0 . 20.0))					; 5
  "Usual viewpoint for display routines")
;
;	Current viewpoint; can be changed.
;
(defvar viewpoint vp "Current viewpoint")
;
;	trim  --  trim string to no more than indicated number of elements
;
;	Actually, this will work on any sequence.
;
(defun trim (seq lim)
	(subseq seq 0 (min lim (length seq))))
;
;      showob  --  add object to display.
;
;	The local variable names here are confusing; X and Y are two
;	points, not two coordinates.
;
(defun showob (b)
  (prog (x y z v f l cv pf item nv nf nl lp)
	(unless (setq item (present (list 'at b '*)))	; where is block B?
		(error "~A not present - showob" b))
	(setq v (getverts b))			; get vertices
	(setq f (getfacep b))			; get face planes
	(setq l (block-edges b))		; edges of block
	(setq lp (getedgefaces b))		; planes bordering edges
	(setq nl (array-dimension l 0))		; number of lines
	(setq nv (array-dimension v 0))		; number of vertices
	(setq nf (array-dimension f 0))		; number of faces
	(setq pf (make-array (list nf)))	; t if hidden face
	;	Translate coordinates of endpoints of lines per viewpoint.
	(setq z (relate-location orgloc (second viewpoint)))
	(setq cv (convert-vertices v z))	; convert vertices per view
	;	Mark faces facing away from the viewpoint, and thus hidden.
	(do ((i 0 (1+ i)))
	    ((= i nf))
	    (store (pf i) (> 
			   (point-plane-distance 
			    (second viewpoint)	; viewpoint coordinates
			    (aref f i)) 	; face to test
			   0.0)))
	;	Plot all the lines of the block.
	;	Edges where both faces are hidden are not displayed.
	(do ((i 0 (1+ i)))
	    ((= i nl))
	    (cond ((and (fourth viewpoint)		; behind viewpoint?
			(null (aref pf (aref lp i 0)))
			(null (aref pf (aref lp i 1)))))
		  ((and (setq x (vconvert (aref cv (aref l i 0))))
			(setq y (vconvert (aref cv (aref l i 1))))
			(plotline (first x) (rest x) (car y) (cdr y))))))
	;	Display block labels if parameter so requests
	(and blocklabels
	     (not (eq b table))		; ignore table
	     (setq x
		   (vconvert 
		    (convert-vertex
		     (convert-vertex (block-cg b) (getat b))
		     z)
		    ))
	     (plottext (first x)
		       (rest x)
		       (trim (string (block-name b)) 60)))))
;
;	vconvert  --  convert to screen coordinates
;
;	Returns (x . y) in screen coordinates.
;
(defun vconvert	(pnt)
  ;	On the screen, X is right and Z is up, so Y is deep.
  (let ((x (* (third viewpoint) (vector3-x pnt)))	; X from converted X
	(y (* (third viewpoint) (vector3-z pnt))))	; Y from converted Z
       ;	Apply perspective transformation.
       (cond ((fourth viewpoint)
	      (unless (> (vector3-y pnt) tol1)
		      (return-from vconvert nil))
	      (setq x (/ x (vector3-y pnt)) 
		    y (/ y (vector3-y pnt)))))
       (cond ((cddddr viewpoint)
	      (setq x (+ (caar (cddddr viewpoint)) x))
	      (setq y (+ (cdar (cddddr viewpoint)) y))))
       ;	Convert coords from -halfscreen..halfscreen to
       ;	0..screen, and drop entire line if any part off.
       (or (> (abs x) halfscreen)
	   (> (abs y) halfscreen)
	   (return-from vconvert (cons (floor (+ halfscreen x))
				       (floor (+ halfscreen y)))))
       (return-from vconvert nil)))
;
;      Display current state as	seen from viewpoint
;
;	This looks like it is intended to be invoked manually.
;	"l" is a label for the display.
;
(defvar plotting nil)			; true if currently plotting
(defun show (&optional l)
  (when plotting
	(ploterase)
	(mapc 'showob (getobs))		; show all objects
	(when l				; if labelled
	      (plottext 0 0 (trim (string l) 60))) ; show label
	(plotflush)))			; flush file
;
;	plot  --  create UNIX plot file
;
;	This is a temporary expedient until we get the LISP system
;	hooked up to the graphics software.
;
;	(plot FILENAME)		starts plotting to FILENAME
;	(plot nil)		turns it off
;	(plot)			does a redraw
;
;	If one runs 
;
;		tail -f FILENAME | plot
;
;	in a Tektronix emulator window, dynamic graphics result, sort of.
;
;
(defun plot (&optional (filename t))
  (unless (eq plotting t)		; unless no second arg
	  (plotclose)			; close plotting
	  (setq plotting nil)		; not plotting
	  (unless filename (return-from plot t))
	  (setq plotting (string filename)); new open, force into string
	  (plotopen plotting))		; open plotfile
	  (plotspace (floor fullscreen) (floor fullscreen)) ; set bounds
  (picture-changed nil nil))		; plot current state
;
;	picture-changed  --  picture has changed, update picture
;
;	Temporary version, ignores context information.
;	But we probably want only to plot some requested context.
;
(defun picture-changed (b cntxt)
  (declare (ignore b) (ignore cntxt))	; unused for now
  (when plotting
	(show "Changed")))
