;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; From Tony Barret, U. of Washington.
;;;
;;; Scheduling world
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  (setq o (make-operator :cost 1
      :name '(POLISH $x $prev $t $oldsurf)
    :preconditions '((temperature $x cold)
	       (last-scheduled $x $prev)
	       (later $t $prev)
	       (idle polisher $t)
	       (surface-condition $x $oldsurf))
    :effects '((surface-condition $x polished)
	       (last-scheduled $x $t)
	       (scheduled $x polisher $t)
	       (not surface-condition $x $oldsurf)
	       (not idle polisher $t)
	       (not last-scheduled $x $prev))))
  
  (setq o (make-operator :cost 1
      :name '(ROLL $x $prev $t $oldshape $oldtemp $old-orient $oldwidth)
      :preconditions '((last-scheduled $x $prev)
		       (later $t $prev)
		       (idle roller $t)
		       (shape $x $oldshape)
		       (temperature $x $oldtemp)
		       (surface-condition $x $oldsurf)
		       (painted $x oldpaint)
		       (has-hole $x $oldwidth $old-orient))
      :effects '((temperature $x hot)
		 (shape $x cylindrical)
		 (last-scheduled $x $t)
		 (scheduled $x roller $t)
		 (not shape $x $oldshape)
		 (not temperature $x $oldtemp)
		 (not surface-condition $x $oldsurf)
		 (not painted $x oldpaint)
		 (not has-hole $x $oldwidth $old-orient)
		 (not idle roller $t)
		 (not last-scheduled $x $prev))))
  
  (setq o (make-operator :cost 1
      :name '(LATHE $x $prev $t $oldshape $oldtemp $oldpaint)
      :preconditions '((last-scheduled $x $prev)
		       (later $t $prev)
		       (idle lathe $t)
		       (shape $x $oldshape))
      :effects '((surface-condition $x rough)
		 (shape $x cylindrical)
		 (last-scheduled $x $t)
		 (scheduled $x lathe $t)
		 (not shape $x $oldshape)
		 (not surface-condition $x $oldsurf)
		 (not painted $x $oldpaint)
		 (not idle lathe $t)
		 (not last-scheduled $x $prev))))
  
  (setq o (make-operator :cost 1
      :name '(GRIND $x $prev $t $oldsurf $oldpaint)
    :preconditions '((last-scheduled $x $prev)
	       (later $t $prev)
	       (idle grinder $t)
	       (surface-condition $x $oldsurf)
	       (painted $x $oldpaint))
    :effects '((surface-condition $x smooth)
	   (last-scheduled $x $t)
	   (scheduled $x grinder $t))
    :dele '((surface-condition $x $oldsurf)
	    (painted $x $oldpaint)
	    (idle grinder $t)
	    (last-scheduled $x $prev)))
  
  (setq o (make-operator :cost 1
      :name '(PUNCH $x $t $width $orient)
    :preconditions '((last-scheduled $x $prev)
	       (later $t $prev)
	       (idle punch $t)
	       (temperature $x cold)
	       (surface-condition $x $oldsurf))
    :effects '((has-hole $x $width $orient)
	   (surface-condition $x rough)
	   (last-scheduled $x $t)
	   (scheduled $x punch $t))
    :dele '((surface-condition $x $oldsurf)
	    (idle grinder $t)
	    (last-scheduled $x $prev)))
  
  (setq o (make-operator :cost 1
      :name '(DRILL-PRESS $x $t $width $orient)
    :preconditions '((last-scheduled $x $prev)
	       (later $t $prev)
	       (idle drill-press $t)
	       (temperature $x cold)
	       (have-bit $width))
    :effects '((has-hole $x $width $orient)
	   (last-scheduled $x $t)
	   (scheduled $x drill-press $t))
    :dele '((idle drill-press $t)
	    (last-scheduled $x $prev)))
  
  (setq o (make-operator :cost 1
      :name '(SPRAY-PAINT $x $t $paint)
    :preconditions '((last-scheduled $x $prev)
	       (later $t $prev)
	       (idle spray-painter $t)
	       (temperature $x cold)
	       (sprayable $paint)
	       (surface-condition $x $oldsurf))
    :effects '((painted $x $paint)
	   (last-scheduled $x $t)
	   (scheduled $x spray-painter $t))
    :dele '((surface-condition $x $oldsurf)
	    (idle spray-painter $t)
	    (last-scheduled $x $prev)))
  
  (setq o (make-operator :cost 1
      :name '(IMMERSION-PAINT $x $t $paint)
    :preconditions '((last-scheduled $x $prev)
	       (later $t $prev)
	       (idle immersion-painter $t)
	       (have-paint-for-immersion $paint))
    :effects '((painted $x $paint)
	   (last-scheduled $x $t)
	   (scheduled $x immersion-painter $t))
    :dele '((idle immersion-painter $t)
	    (last-scheduled $x $prev))))

(defun init-sched (&aux ret)
  (setf ret nil)
  (dolist (x '(polisher roller lathe grinder punch drill-press 
	       spray-painter immersion-painter))
    (dolist (y '(time-1 time-2 time-3 time-4 time-5))
      (push (list 'idle x y) ret)))
  
  (dolist (x '(.1 .2 .3))
    (push (list 'has-bit x) ret))
  
  (dolist (x '(have-paint-for-immersion sprayable))
    (dolist (y '(red black))
      (push (list x y) ret)))
  
  (do ((x '(time-0 time-1 time-2 time-3 time-4 time-5) (cdr x)))
      ((null (cdr x)))
    (do ((y (cdr x) (cdr y)))
	((null y))
      (push (list 'later (car y) (car x)) ret)))
  
  ret)

(defun sched-test ()
  (scheduling-world-domain)
  (plan (append (init-sched)
		'((shape obj-A oblong)
		  (temperature obj-A cold)
		  (surface-condition obj-A rough)
		  (painted obj-A none)
		  (has-hole obj-A 0 nil)
		  (last-scheduled obj-A Time-0)
		  
		  (shape obj-B cylindrical)
		  (temperature obj-B cold)
		  (surface-condition obj-B smooth)
		  (painted obj-B red)
		  (has-hole obj-B 0 nil)
		  (last-scheduled obj-B Time-0)))
	'((shape Obj-A cylindrical)
	  (surface-condition Obj-B polished))))


