%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (C)1992 Institute for New Generation Computer Technology %
% $BG[I[$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F2<$5$$(B          %
% ( Read COPYRIGHT for detailed information. )             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- public tran/0. 
:- op(1000,xfy,[&]).
:- op(1000,xfy,['&&']).
:- unknown(_,fail).
tran :-
	/* I/O Session */
	write('Welcome to SAX Compiler Version N1.1'),nl,
	write('(C) ICOT Labs.  1986'),nl,
	write('Enter input file name  :-  '),
	ttyflush,
	read(I_file),
	write('Enter output file name :- '),
	ttyflush,
	read(O_file),

	/* FILE Digestion */
	display('Enter Top Node (default is sentence for key in y.) '),
	ttyflush,
	read(TOPNODE),
	(TOPNODE == y,TNODE = sentence;TOPNODE = TNODE),
	display('Enter Arguments for top node (default is 2 for key in y) '),
	ttyflush,
	read(ArguNumb),
	(ArguNumb == y,
	 Anumb = 2,
	 Alist = [A,B]
	;
	 ArguNumb = Anumb,
	 g_args(Anumb,Alist)),
	recdz(Table,(TNODE,Anumb),type2,
			(middle,arg(Alist),(begin,[]),
			(end,Alist),{true})),
	statistics(runtime,_),
	op(1000,xfy,[&]),
	see(I_file),
	read(Rule),!,
	path1(Rule,Table,Id_table,HList),nl,
        display('> Unused NT <'),nl,
        check_x(HList,Table),nl,
	write('>> Finished Path 1 << '),nl,
	display(' > SAX Clause Generation <'),ttynl,
	tell(O_file),
        write(' :- unknown(_,fail).'),nl,
	p_process(Table),
        

	/* Link Generation */	

	display(' > Link Generation < '),ttynl,ttynl,
	nl,write('/**** Link ****/'),nl,nl,
	put_link,

	/* ID GENERATION */
	display(' > Id_Table Generation < '),ttynl,ttynl,
	nl,write('/**** Id_Table ****/'),nl,
	id_tbl(Id_table),write(id_pair(begin,TNODE)),write('.'),nl,
	told,
	write('>> Finished Path 2 <<'),nl,
	statistics(runtime,[_,Time]),
	write('>> End of translation <<'),nl,
	write('   Execution time = '),
	write(Time),
	write(' msec'),nl,
	abolish(curr_int,1),!.


g_args(0,[]) :- !.
g_args(N,[A|R]) :-
	NN is N - 1,!,
	g_args(NN,R).

path1(end_of_file,Table,Id_Table,[]) :- !.

path1((Head --> BodyO),Table,Id_Table,[Head|HT]) :- 
	get_lastc(BodyO,Body,LastC),
	path1_top(Body,      [],(Head,LastC),  XX),
	path1_bottom(Head,LastC,XX,Table,Id_Table),
	read(Rule),write('*'),ttyflush,!,
	path1(Rule,Table,Id_Table,HT).


path1((Head :- Body),Table,Id_Table,HList) :-
      	tell('prolog.prog'),
	write(Head),
	write(' :-'),nl,
	put(9),
	write(Body),
	write('.'),nl,
	told,
	read(Rule),!,
	path1(Rule,Table,Id_Table,HList).
path1(Term,Table,Id_Table,HList) :-
      	tell('prolog.prog'),
	write(Term),
	write('.'), nl,
	told,
	read(Rule),!,
	path1(Rule,Table,Id_Table,HList).

p_process(Table) :-
	put_pub(Table),
	nontm(Table),
	para_rules(Table),!.

put_pub(Table) :-
	write(':- public '),
	select(Table,(Name,Numb),_),
	B is Numb + 4,
	put(9),
	write(Name),
	write('/'),
	write(B),
	write(', '),nl,
	fail.
put_pub(_) :-
	write('fin/1.'),nl,nl.


nontm(Table) :-
	select(Table,(Name,Numb),Data),
	both(Data),
	v_narg_l(Numb,Arg,['LC']),

	T =.. [Name,'X'|Arg],
	concat_atoms(Name,'_zz1',N1_Name),
	T1 =.. [N1_Name,'X'|Arg],
	concat_atoms(Name,'_zz2',N2_Name),
	T2 =.. [N2_Name,'X'|Arg], 
	Terms =.. [-->,T,(T1,T2)],
	out_terms(Terms),
	fail.
nontm(_).

v_narg_l(Numb,Arg,LC) :-
	v_narg_l1(Numb,0,Arg,LC).
v_narg_l1(Numb,Numb,T,T) :- !.
v_narg_l1(Numb,NT,['$VAR'(NT)|T],R) :-
	NN is NT + 1,!,
	v_narg_l1(Numb,NN,T,R).

concat_atoms(N,L,NL) :-
	name(N,N_atoms),name(L,L_atoms),append(N_atoms,L_atoms,AL),
	name(NL,AL).


out_terms((Hd --> Bd)) :- 
	write(Hd),write(' --> '),!,
	out_terms1(Bd),
	write('.'),nl,nl.
out_terms1(((B;[]),R)) :-
	nl,write('     ('),
	out_terms1(B),
	nl,write('     ; []),'),
	out_terms1(R).
out_terms1((B,R)) :-
	nl,write('       '),
	write(B),
	(nonvar(R),
		write(','),!,
		out_terms1(R)
	;true).
out_terms1(R) :-
	nl,write('       '),!,
	write(R).

both(Data) :-
	select(Data,type2,_),!,
      (	select(Data,type1,_) ;
	select(Data,type10,_) ),!.

para_rules(Table) :-
	select(Table,Term,Data),	% Term b, Data [[type1,..],[type10,..],
					% 		[type2,..]].
	del(Data,type2,Tp2,Tp1),	% Tp2 [(last,..),(middle,..)]
					% Tp1 [[type1,..],[type10,..]]
	type_one(Term,Tp1,Tp2),		%
	type_two(Term,Tp2,Tp1),
	fail.
para_rules(_).

type_one(Term,Data,Tp2) :-		% Term b, Data [[type,.],[type10,.]]
	del(Data,type10,Tp10,Tp1),
	tp_one(Term,Tp1,Tp10,Tp2),!.

tp_one(_,[],[],_) :- !.			% b,[type1,.],[type10,.],[type2,.]
tp_one((Term,Numb),[],Tp10,Tp2) :-	
      ( Tp2 = [],NTerm = Term ;
	concat_atoms(Term,'_zz1',NTerm)),
	v_narg_l(Numb,Arg,['LC']),
	T =..[NTerm,'X'|Arg],
	type_ten(Tp10,1,[],R),nl,
	Terms =.. [-->,T,R],
	out_terms(Terms),!.

tp_one((Term,Numb),Tp1,Tp10,Tp2) :-	
      ( Tp2 = [] ,NTerm = Term;
	concat_atoms(Term,'_zz1',NTerm)),
	v_narg_l(Numb,Arg,['LC']),
	T =.. [NTerm,'X'|Arg],
	tp_one_body(Tp1,(Term,Numb),1,I,Tp10,Tp10_rest,[],1,Last,R,RR),
	type_ten(Tp10_rest,I,Last,RR),nl,
	Terms =.. [-->,T,R],
	out_terms(Terms),!.

get_aschii(N,C) :- D is N + 48,C =.. [D].

tp_one_body([[type1|Rest]|Rest2],A,B,C,D,E,F,G,H,R,RR):-
			tp_one_body1(Rest,A,B,C,D,E,F,G,H,R,RR).

tp_one_body1([],_,I,I,Tp10,Tp10,Pre,II,Pre,R,R) :- !.
tp_one_body1([(Head,Ids)|Rest],(Term,Numb),Intold,I,Tp10,Tp,Pre,J,Last,R,R4) :-
	Head =.. [Hname|B],
        length(B,C),
	Ids = (arg(Arg),(Id,Var),Ext),

     ( 	(Term == Hname,C =:= Numb, Int = Intold, Pre2 = Pre,
		length(Arg,SS),  
		(Ext = {true},
			R = (Term1,R2)
		;
			ext_w(Arg,Ext,Ext1),
		 	R = ((Ext1,Term1;[]),R2)
		),
		length(Var,LL),
		(LL == 0,
			Var2 = ['LC']
		;
			ext_w(Arg,Var,Var22),
			append(Var22,[['LC']],Var2)),
		IDTerm =.. [Id,'X'|Var2],
		concat_atoms('T',J,TJ),
		Term1 =.. [tp_out,'X',[IDTerm|TJ],TJ]
	)
      ; 
	 Pre2 = Hname,
	( 	(Hname = Pre,Int = Intold,
			R = R21
		;
			 Int is Intold + 1,
			concat_atoms('New_X',Int,NewXINT),
			Term0 =.. [tp_ck,'X',Hname,NewXINT],
			R = ({Term0},R21)
		),
	   	length(Arg,OO),
		( Ext = {true},
			R21 = (Term1,R2)
		;	
			ext_w(Arg,Ext,Ext1),
 			R21 = (({NewXINT \== []},Ext1,Term1;[]),R2)
		),
	   	length(Var,CC),
	   	(CC == 0,
			Var3 = ['LC']
		;
			ext_w(Arg,Var,Var3_1),
			append(Var3_1,[['LC']],Var3)),
		concat_atoms('New_X',Int,NewXINT),
		IDTerm =.. [Id,NewXINT|Var3],
		concat_atoms('T',J,TJ),
		Term1 =.. [tp_out,NewXINT,[IDTerm|TJ],TJ]
	)
     ),
	( del(Tp10,Head,Tp10_rest),
		Term3 =.. [Head,NewXINT],
		R2 = (Term3,R3)
	;
		Tp10 = Tp10_rest,
		R2 = R3 
	),
	Jn is J + 1,
	tp_one_body1(Rest,(Term,Numb),Int,I,Tp10_rest,Tp,Pre2,Jn,Last,R3,R4).

spool_tens([Id|Rest]) :-
	write(Id),
	write('(X)'),
      ( Rest = [] ;
	write(','),!,
	spool_tens(Rest) ),!.


spool([Id|Rest],Int) :-
	write(Id),
	write('(New_X'),write(Int),write(')'),
      ( Rest = [] ;
	write(','),!,
	spool(Rest,Int) ),!.

type_ten([],_,_,'!') :- !.
type_ten([(Head,arg(X),Ext,(HT,LC),_)|Rest],Intold,Pre,R) :-
	Head =.. [Hname|Arg],
	Pre2 = Hname,
      	(Hname = Pre,
		Int = Intold,
		concat_atoms('New_X',Int,NewXIntC),
		R = R1
	; 
		Int is Intold + 1,
		concat_atoms('New_X',Int,NewXIntC),
		Term1 =.. [tp_ck,'X',Hname,NewXIntC],
		R = ({Term1},R1)
	),
	length1(X,C),!,

	(Ext = {true},
		R1 = (Term2,R3)
	;
		ext_w(X,Ext,Ext1),
		R1 = (({NewXIntC \== []},Ext1,Term2;[]),R3)
	),
	length(Arg,CC),
	(CC == 0,
		A1 = A2
	;
		ext_w(X,Arg,Arg2),
		append(Arg2,A2,A1)
	),
	ext_w(X,LC,LCCCC),
	A2 = [[HT,LCCCC,'LC']],
	Term2 =.. [Hname,NewXIntC|A1],
	type_ten(Rest,Int,Pre2,R3).

type_two((Term,C),Data,Tp1) :-
	Data \== [],!,
      ( Tp1 = [],TT = Term ;
	concat_atoms(Term,'_zz2',TT)),	% TT can be used other step
	v_narg_l(C,Arg2,['LC']),
	TT1 =.. [TT,[]|Arg2],
	Terms =.. [-->,TT1,('!')],
	out_terms(Terms),

 	TU2 =.. [TT,'[Id|Tail]'|Arg2],
	concat_atoms(Term,'_h',TH),	% TH can be used other step
	TU4 =.. [TH,'Id'|Arg2],
	TU5 =.. [TT,'Tail'|Arg2],
	TU6 =.. [-->,TU2,(TU4,'!',TU5)],
	out_terms(TU6),

	TV0 =.. [TT,'[_|T]'|Arg2],
	TV1 =.. [TT,'T'|Arg2],
	TV2 =.. [-->,TV0,('!',TV1)],
	out_terms(TV2),

	tp2_main((Term,C),Data,Tp1),!.

type_two(_,_,_).


tp2_main(Term,Cases,Tp1) :- 
	tp2_ml(Cases,Term,Tp1),!.

tp2_ml([],_,_) :- !.
tp2_ml([(middle,arg(Arg),(ID1,Var1),(ID2,Var2),Ext)|Rc],(Term,C),Tp1) :-
	concat_atoms(Term,'_h',TH),

	length(Var1,CC),
	(CC == 0,
		ID1_var = ['LC']
	;
		ext_w(Arg,Var1,FF),
		append(FF,['LC'],ID1_var)),
	TID1 =.. [ID1,'X'|ID1_var],
	v_narg_l(C,TH_arg,['LCC']),
	Thead =.. [TH,TID1|TH_arg],

     	length(Arg,EE),

      ( Ext = {true},
		ML_0 = ([TID2],ML_N)
	;
		ext_w(Arg,Ext,Ext1),
		ML_0 = ((Ext1,[TID2];[]),ML_N)
      ),
	length(Var2,C2),
	(C2 == 0,
		AID2 = ['[LCC|LC]']
	;
		ext_w(Arg,Var2,AID22),
		append(AID22,['[LCC|LC]'],AID2)),
	TID2 =.. [ID2,'X'|AID2],
	last_eval(Rc,RRc,arg(Arg),(ID1,Var1),(Term,C),Tp1,ML_N,'!'),
	TY2_ML =.. [-->,Thead,ML_0],
	out_terms(TY2_ML),!,
	tp2_ml(RRc,(Term,C),Tp1).

tp2_ml([(last,arg(Arg),(ID,Var1),Head,Ext,(HT,LC),_)|Rc],(Term,C),Tp1) :-
	concat_atoms(Term,'_h',TH),
	length(Var1,CC),
	(CC == 0,
		ID1_var = ['LC']
	;
		ext_w(Arg,Var1,FF),
		append(FF,['LC'],ID1_var)),
	TID1 =.. [ID,'X'|ID1_var],
	v_narg_l(C,TH_arg,['LCC']),
	Thead =.. [TH,TID1|TH_arg],
	ML_0 = (Thead --> MML),

	length(Arg,RR),
       (Ext = {true},
		MML = (L_Term,ML_N)
	;
		ext_w(Arg,Ext,Ext1),
		MML = (Ext1,(L_Term,ML_N))
	),

	Head =.. [Hname|Args],
	length(Args,CCC),

	ext_w(Arg,LC,LCCC),	

	(CCC == 0,
		LTHA = [[HT,LCCC,'LCC|LC']]
	;
		ext_w(Arg,Args,Args2),
		append(Args2, [[HT,LCCC,'LCC|LC']],LTHA)
	),
	L_Term =.. [Hname,'X'|LTHA],
	lastm_eval(Rc,RRc,arg(Arg),(ID,Var1),(Term,C),Tp1,ML_N,'!'),
	out_terms(ML_0),
	tp2_ml(RRc,(Term,C),Tp1).

id_tbl([]) :- !.
id_tbl([(Id,Term)|I_table]) :-
	write('id_pair('),
	write(Id), write(','),
	Term =.. [Name|_],
	write(Name),write(').'),nl,!,
	id_tbl(I_table).

:- mode new_id(-).
new_id(ID) :-
	genint(Int),
	name(Int,LInt),
	name(ID,[105,100|LInt]),!.

:- mode genint(-).
genint(Int) :-
      (	curr_int(Int) ;
	Int = 1 ),
	Int1 is Int + 1,
	abolish(curr_int,1),
	assert(curr_int(Int1)), !.


recdz([[Key|Data]|_],Key,Arity,Term) :- !,
	put_data(Data,Arity,Term).
recdz([_|Tail],Key,Arity,Term) :- !,
	recdz(Tail,Key,Arity,Term).

put_data([[Arity|List]|_],Arity,Term) :- !,
	insert(Term,List).
put_data([_|Tail],Arity,Term) :- !,
	put_data(Tail,Arity,Term).

insert(A,X) :- var(X),X = [A|_].
insert(A,[X|_]) :- var(X),A = X.
insert(A,[B|_]) :- A == B.
insert(A,[_|R]) :- insert(A,R).

:- mode last_be(?,+,-).
last_be(X,Y,Y) :-
	var(X), !.
last_be([A|X],Y,[A|Z]) :- !,
	last_be(X,Y,Z).

:- mode select(?,?,-).
select([],_,_) :-
	!,fail.
select([[Term|Data]|_],Term,Data).
select([_|Tail],Term,Data) :-
	select(Tail,Term,Data).

:- mode del(-,?).
del(_,[]) :-
	!,fail.
del(Term,[Term|_]).
del(Term,[_|Rest]) :-
	del(Term,Rest).

del([],_,_) :- !,fail.
del([Term|Rest],Term,Rest) :- !.
del([Head|Rest],Term,[Head|Rest1]) :- !,
	del(Rest,Term,Rest1).

del([],_,[],[]) :- !.
del([[Type|Data]|Rest],Type,Data,Rest) :- !.
del([L|Rest],Type,Data,[L|Rest1]) :-
	del(Rest,Type,Data,Rest1),!.

:- mode cdr_of(?,+,-).
cdr_of(X,_,X) :- var(X),!.
cdr_of([[Term|Tail]|_],Term,Tail) :- !.
cdr_of([_|Rest],Term,Tail) :- !,
	cdr_of(Rest,Term,Tail).

top(1) :- print('enter file name'),nl,read(FILE),see(FILE),top1.
top1 :- read(X),X = (A --> B),jack(A,B,RDR),top1.
top1 :- seen.
top(2,Table) :- print('enter file name'),nl,read(FILE),see(FILE),top2(Table).
top2(Table) :- read(X),process(X,Table,A,At),top2(Table).
top2(Table) :- seen.

jack(A,B,RDR) :-   
	digest((A,B),(RR1,Rt),0),
	madx((RR1,Rt),(RR,Rt)),  
	RR = [CNT|_],
	mktb((RR,Rt),Res3),	 
	arran(Res3,RDR,CNT).

digest(({A},Rest),(T,Tt),C) :- 
	diflat(A,(T,At)),!,
	digest(Rest,(At,Tt),C).
digest({A},(T,Tt),C) :- 
	diflat(A,(T,Tt)).
digest((';'(A,B),Rest),(T,Tt),C) :- 
	T=[CC|TT],
	diflat(A,(TT,U)),
	diflat(B,(U,V)),
	CC is C+1,!,
	digest(Rest,(V,Tt),CC).
digest(';'(A,B),(T,Tt),C) :- 
	T=[CC|TT],
	diflat(A,(TT,U)),
	diflat(B,(U,Tt)),
	CC is C+1.
digest((A,Rest),(T,Tt),C) :- 
	T=[CC|TT],
	diflat(A,(TT,U)),
	CC is C+1,!,
	digest(Rest,(U,Tt),CC).
digest(A,(T,Tt),C) :- 
	T=[CC|U],
	A =.. [_|RR],
	diflat(RR,(U,Tt)),
	CC is C+1.

diflat(A,([A|Tt],Tt)) :- var(A).
diflat(A,(T,T)) :- atomic(A).
diflat((A,Rest),(T,Tt)) :- 
	(var(A),
	 T=[A|B],!,
	 diflat(Rest,(B,Tt))
	;
	 atomic(A),!,
	 diflat(Rest,(T,Tt))).
diflat([A|B],(T,Tt)) :- 
	var(A),
	T=[A|U],
	diflat(B,(U,Tt)).
diflat([A],([A|Tt],Tt)) :- var(A).
diflat([[]],(T,T)).
diflat(({A},Rest),(T,Tt)) :- 
	diflat(A,(T,U)),!,
	diflat(Rest,(U,Tt)).
diflat({A},(T,Tt)) :- diflat(A,(T,Tt)).
diflat((';'(A,B),Rest),(T,Tt)) :- 
	diflat(A,(T,U)),
	diflat(B,(U,V)),!,
	diflat(Rest,(V,Tt)).
diflat((A,Rest),(T,Tt)) :- 
	diflat(A,(T,U)),
	diflat(Rest,(U,Tt)).
diflat(A,(TT,Tt)) :- 
	A =.. [_,E|ER],
	diflat(E,(TT,UU)),!,
	diflat(ER,(UU,Tt)).


madx(([_|R],Rt),([Max|R],Rt)) :- dmax((R,Rt),0,Max).
dmax((Ra,Rt),N,N) :- Ra == Rt.
dmax(([A|R],Rt),N,M) :- (var(A),dmax((R,Rt),N,M);
			 A > N, dmax((R,Rt),A,M);
				dmax((R,Rt),N,M)).

mktb(([A|Res],Rt),Table) :- integer(A),tsume(A,Res,Table).

tsume(_,A,_) :- var(A).
tsume(A,[S|R],Table) :- integer(S),tsume(S,R,Table).
tsume(A,[S|R],Table) :- mktb1(Table,S,A),tsume(A,R,Table).

mktb1(A,Key,Arg) :- var(A),A=[[Key,Data]|_],!,ins(Data,Arg).
mktb1([[Key1,Data]|_],Key,Arg) :- Key==Key1,!,ins(Data,Arg).
mktb1([_|Rest],Key1,Arg) :- mktb1(Rest,Key1,Arg).

ins([Arg|_],Arg).
ins([_|Rest],Arg) :- ins(Rest,Arg).

arran(Table,RTable,Cnt) :-   se2(Table,Cnt,Mtable),
			     se1(Mtable,Cnt,2,RTable).
cmax(Table,Cnt) :- cmax1(Table,0,Cnt).
cmax1(Table,Ocnt,Ocnt) :- var(Table).
cmax1([[_|[Table]]|Rest],Ocnt,Cnt) :- max2(Table,0,Ncnt),
				(Ocnt < Ncnt,cmax1(Rest,Ncnt,Cnt);
				 cmax1(Rest,Ocnt,Cnt)).
max2(A,Oc,Oc) :- var(A).
max2([A|R],Oc,Nc) :- ((Oc < A),max2(R,A,Nc);max2(R,Oc,Nc)).
les2(A,Oc,Oc) :- var(A).
les2([A|R],Oc,Nc) :- ((Oc > A),les2(R,A,Nc);les2(R,Oc,Nc)).

se2(A,Cnt,[]) :- var(A).
se2([[A|[Table]]|Rest],Cnt,[[A|LL]|Ret]) :- 
		les2(Table,Cnt,Lcnt), 
		max2(Table,0,Mcnt),
		mkmdl(Lcnt,Mcnt,LL),
	        se2(Rest,Cnt,Ret).

mkmdl(Mcnt,Mcnt,[]).
mkmdl(Lcnt,Mcnt,[Lcnt|Res]) :- Next is Lcnt + 1,mkmdl(Next,Mcnt,Res).

se1(_,Cnt,Cntt,[[]]) :- Cntt >= Cnt.
se1(Mtable,Cnt,Cntt,[Resl|Ret]) :- fsf(Mtable,Cntt,Resl),
				   LL is Cntt+1,!,se1(Mtable,Cnt,LL,Ret).
fsf([],Cntt,[]).
fsf([[A|R]|Rest],Cntt,[A|RR]) :- member(Cntt,R),fsf(Rest,Cntt,RR).
fsf([_|Rest],Cntt,RR) :- fsf(Rest,Cntt,RR).
member(A,[A|_]).
member(A,[_|R]) :- member(A,R).

pop_sem(A,X) :- A =.. [_|X].

captl(A,C) :- name(A,H),captl1(H,B),name(C,B).
captl1([],[]).
captl1([A|R],[A|RE]) :-  A>=48,A=<57,captl1(R,RE).
captl1([A|R],[B|RE]) :- B is A - 32,captl1(R,RE).


synmk((Top,Trest),[Ret|In]) :- Top =.. [Name|_],
			       synmk1(Trest,In),Ret =.. [Name|In].
synmk1(([A],Rest),[A|R]) :- synmk1(Rest,R).
synmk1(([A]),[A]).
synmk1(({A},Rest),R) :- synmk1(Rest,R).
synmk1(({A}),[]).
synmk1((A,Rest),[TOP|R]) :- A =.. [Top|_],captl(Top,TOP),synmk1(Rest,R).
synmk1((A),[TOP]) :- A =.. [Top|_],captl(Top,TOP).

numb_of_arg(Term,Name,Numb) :-
	Term =.. [Name|R],
	count(R,Numb).
count([],0).
count([R|RR],Numb) :- count(RR,O),Numb is O + 1.

n_arg(N) :- nn_arg(N,0).
nn_arg(X,X) :- !.
nn_arg(N,Count) :-
	write(','),
	Numb is Count + 1,
	gen_para(Numb,Var),
	write(Var), !,
	nn_arg(N,Numb).

out_eq(C,Arg) :- out_eq1(1,C,Arg).
out_eq1(D,C,_) :- D > C,!.
out_eq1(X,C,[A|R]) :- NN is X + 1,!,
		gen_para(X,P),write(P),write(' = '),write(A),
		(X =:= C ; write(',')),
		!,out_eq1(NN,C,R).

w_args(A,B) :- !,w_arg1(A),!,w_arg1(B).
w_arg1([]) :- !.
w_arg([A|R]) :- write(A),write(','),!,w_arg(R).

out_args(Cnt,Arg) :-  out_args1(Arg,1,Cnt).
out_args1(_,C,M) :- C > M,!.
out_args1([Arg|R],C,M) :- 
	(nonvar(Arg),Arg =.. [','|_],write('('),write(Arg),write(')')
	;
	write(Arg)),
	(C =:= M;write(',')),
	CC is C + 1,!,out_args1(R,CC,M).

length1(X,C) :- length(X,C).

de.
debugf.

ext_w(Var_l,Ext_f0,Ext_f1) :-  var(Ext_f0),!,exch_var(Var_l,Ext_f0,Ext_f1).
ext_w(Var_l,Ext_f0,Ext_f0) :-  atomic(Ext_f0).
ext_w(Var_l,[E0|R0],[E1|R1]) :- ext_w(Var_l,E0,E1),!,ext_w(Var_l,R0,R1).
ext_w(Var_l,{E0},{E1}) :- ext_w(Var_l,E0,E1).
ext_w(Var_l,Ext_f0,Ext_f1) :- 
		Ext_f0 =.. [E|R],ext_w(Var_l,E,E2),ext_w(Var_l,R,R2),
		Ext_f1 =.. [E2|R2].

exch_var(Var_l,Var,Out) :- vmember(Var,Var_l,Out,1).
exch_var(Var_l,Var,Var).

vmember(Var,[],Var,_).
vmember(Var,[A|_],Out,C) :- Var == A,
			    gen_para(C,Out).
vmember(Var,[_|R],Out,C) :- CC is C + 1,vmember(Var,R,Out,CC).


gen_para(N,'$VAR'(N1)) :- N1 is N -1.


get_lastc(A,B,C) :- remove_lex(A,A1),
		get_lastc1(A1,B,C).
remove_lex((A&&_),A) :- !.
remove_lex((A,B),(A,D)) :- !,
	remove_lex(B,D).
remove_lex((A&B),(A&D)) :- !,
	remove_lex(B,D).
remove_lex(A,A) :- !.
get_lastc1((A,B),(A,Br),C) :- !,
	get_lastc1(B,Br,C).
get_lastc1((A&B),A,B) :- !.
get_lastc1(A,A,{true}) :- !.

path1_top([],_,_,[]) :- !.
path1_top(Body,Pre,Post,Table) :- 
		path1_1(Body,Pre,Post,XX),!,
		cont_path1(Pre,Post,Body,XX,Table).

path1_1(Body,Pre,Post,Table) :- 
		ptail(true,{Post},H),ptail(para(Pre),Body,Body1),
		jack(H,Body1,[_|T_var]),
		set_env(Body,T_var,Table).

set_env(Body,[[]],[Body]) :- !.
set_env(Body,[Var0|R_var],[B1,(ID0,Var0)|T]) :- 
			new_id(ID0),disp(Body,B1,B2),!,
			set_env(B2,R_var,T).

:- mode cont_path1(+,+,+,+,-).

cont_path1(_,_,[],_,[]).
cont_path1(Pre,Post,(';'(Body1,Body2),R),[_,(Id1,Var)|Re],
					[[or,X1,X2],(Id1,Var)|T]) :-
		path1_top(Body1,Pre,Var,X1),
		path1_top(Body2,Pre,Var,X2),!,
		cont_path1(Var,Post,R,Re,T).
cont_path1(Pre,Post,';'(Body1,Body2),[_],[[or,X1,X2]]) :-
		path1_top(Body1,Pre,Post,X1),!,
		path1_top(Body2,Pre,Post,X2).
cont_path1(Pre,Post,Body,[F,(Id1,Var)|Re],[F,(Id1,Var)|T]) :-
		disp(Body,B1,B2),!,
		cont_path1(Var,Post,B2,Re,T).
cont_path1(Pre,Post,Body,[F],[F]) :- !.


disp((X,{Y}),(X,{Y}),[]) :- !.
disp((X,{Y},Z),(X,H),R) :- !, ex_ut(Z,{Y},H,R).
disp((X,Y),X,Y) :- !.
disp(X,X,[]).

ex_ut({Z},Y,(Y,{Z}),[]) :- !.
ex_ut(({M},Z),Y,(Y,H),R) :- !,ex_ut(Z,{M},H,R).
ex_ut(Z,Y,Y,Z).


ptail((A,B),Tail,(A,R)) :- ptail(B,Tail,R).
ptail(A,Tail,(A,Tail)).

path1_bottom(Head,LastC,Body,Table,Id_Table) :-
	Undeterm = [],F_id = [],Sign = [],O_F_id = [],
	trail(Head,LastC,Body,Undeterm,F_id,O_F_id,Sign,Table,Id_Table).

trail(_,_,[],_,_,_,_,_,_) :- !.
trail(Head,LC,[[or,A,B]|R],Undeterm,F_id,O_F_id,Sign,Table,Id_Table) :-
		sappend(A,R,C),sappend(B,R,CC),
		trail(Head,LC,C,Undeterm,F_id,O_F_id,Sign,Table,Id_Table),!,
		trail(Head,LC,CC,Undeterm,F_id,O_F_id,Sign,Table,Id_Table).
trail(Head,LC,[[or,A,B]],Undeterm,F_id,O_F_id,Sign,Table,Id_Table) :-
		sappend(A,[],C),sappend(B,[],CC),
		trail(Head,LC,C, Undeterm,F_id,O_F_id,Sign,Table,Id_Table),!,
		trail(Head,LC,CC,Undeterm,F_id,O_F_id,Sign,Table,Id_Table).

trail(Head,LC,[[],_|B],[],F_id,O_F_id,Sign,Table,Id_Table) :- !,
		trail(Head,LC,B,[],_,O_F_id,Sign,Table,Id_Table).

trail(Head,LC,[[]],[],F_id,O_F_id,Sign,Table,Id_Table) :- !.

trail(Head,LC,[A,N_F_id|B],[],F_id,O_F_id,Sign,Table,Id_Table) :- !,
		trail(Head,LC,B,A,N_F_id,O_F_id,type110,Table,Id_Table).

trail(Head,LC,[B],[],F_id,O_F_id,Sign,Table,Id_Table) :-  
		fsets(type10,LC,Head,B,[],R1,R2),!,
		recdz(Table,R1,type10,R2).


trail(Head,LC,[[]],Undeterm,F_id,O_F_id,type2,Table,Id_Table) :- 
		 fsets(last,LC,Head,Undeterm,O_F_id,R1,R2),!,
		 recdz(Table,R1,type2,R2).
trail(Head,LC,[[]],Undeterm,F_id,O_F_id,type110,Table,Id_Table):- 
		 fsets(type10,LC,Head,Undeterm,[],R1,R2),!,
		 recdz(Table,R1,type10,R2).

trail(Head,LC,[[],N_F_id|B],Undeterm,F_id,O_F_id,type2,Table,Id_Table) :- !,
		trail(Head,LC,B,Undeterm,F_id,O_F_id,type2,Table,Id_Table).

trail(Head,LC,[[],N_F_id|B],Undeterm,F_id,O_F_id,type110,Table,Id_Table) :- !,
		trail(Head,LC,B,Undeterm,F_id,O_F_id,type110,Table,Id_Table).

trail(Head,LC,[B],Undeterm,F_id,O_F_id,type2,Table,Id_Table) :- 
		fsets(middle,LC,Head,Undeterm,(O_F_id,F_id),R1,R2),
		recdz(Table,R1,type2,R2),
		gsets(Id_Table,B,F_id),!,
		trail(Head,LC,[[]],B,_,F_id,type2,Table,Id_Table).

trail(Head,LC,[B],Undeterm,F_id,O_F_id,type110,Table,Id_Table) :- 
		fsets(type1,LC,Head,Undeterm,F_id,R1,R2),
		recdz(Table,R1,type1,R2),
		gsets(Id_Table,B,F_id),!,
		trail(Head,LC,[[]],B,_,F_id,type2,Table,Id_Table).

trail(Head,LC,[A,N_F_id|B],Undeterm,F_id,O_F_id,type2,Table,Id_Table) :-
		fsets(middle,LC,Head,Undeterm,(O_F_id,F_id),R1,R2),
		recdz(Table,R1,type2,R2),
		gsets(Id_Table,A,F_id),!,
		trail(Head,LC,B,A,N_F_id,F_id,type2,Table,Id_Table).

trail(Head,LC,[A,N_F_id|B],Undeterm,F_id,O_F_id,type110,Table,Id_Table) :-
		fsets(type1,LC,Head,Undeterm,F_id,R1,R2),
		recdz(Table,R1,type1,R2),
		gsets(Id_Table,A,F_id),!,
		trail(Head,LC,B,A,N_F_id,F_id,type2,Table,Id_Table).

sappend([],A,[[]|A]) :- !.
sappend(A,B,C) :- !,append(A,B,C).
append([],A,A) :- !.
append([A|R],L,[A|RR]) :- !,append(R,L,RR).

fsets(type10,LC,Head,(Body,{Ext_f}),ID,
		(Term,LL),(Head,arg(Arg),{Ext_f},(Targ,LC),ID)) :- 
	functor(Head,Targ,_),
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg],link_memo(Term,Head)),!.
fsets(type10,LC,Head,Body,ID,
		(Term,LL),(Head,arg(Arg),{true},(Targ,LC),ID)) :- 
	functor(Head,Targ,_),
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg],link_memo(Term,Head)),!.
	
fsets(last,LC,Head,(Body,{Ext_f}),ID,
		(Term,LL),(last,arg(Arg),ID,Head,{Ext_f},(Targ,LC),[])) :-
	functor(Head,Targ,_),
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg]),!.
fsets(last,LC,Head,Body,ID,
		(Term,LL),(last,arg(Arg),ID,Head,{true},(Targ,LC),[])) :-
	functor(Head,Targ,_),
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg]),!.

fsets(middle,LC,Head,(Body,{Ext_f}),(ID_old,ID_new),
		(Term,LL),(middle,arg(Arg),ID_old,ID_new,{Ext_f})) :-
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg]),!.
fsets(middle,LC,Head,Body,(ID_old,ID_new),
		(Term,LL),(middle,arg(Arg),ID_old,ID_new,{true})) :-
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg]),!.

fsets(type1,LC,Head,(Body,{Ext_f}),F_id,
		(Term,LL),(Head,arg(Arg),F_id,{Ext_f})) :-
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg],link_memo(Term,Head)),!.
fsets(type1,LC,Head,Body,F_id,
		(Term,LL),(Head,arg(Arg),F_id,{true})) :-
	(Body = [Term],LL = 0,Arg = [];
	 functor(Body,Term,LL),Body =.. [_|Arg],link_memo(Term,Head)),!.
	
gsets(Id_Table,(F,{_}),(ID,Var)) :- (F = [A];F = A),!,insert((ID,A),Id_Table).
gsets(Id_Table,F,(ID,Var)) :- (F = [A];F = A),!,insert((ID,A),Id_Table).

last_eval([],[],_,_,_,_,X,X) :- !.  
last_eval([(middle,A,B,C,D)|R],[(middle,A,B,C,D)|RRc],
	arg(Alist),(IDX,Ilist),TermC,Tp1,X,Y) :-
	last_eval(R,RRc,arg(Alist),(IDX,Ilist),TermC,Tp1,X,Y),!.
last_eval([(last,arg(Alist1),(IDX1,Ilist1),Head,EXT,Taa)|R],RRc,
	         arg(Alist2),(IDX2,Ilist2),(Term,C),Tp1,THA,TH_last) :-
	(Alist1 == Alist2,IDX1 == IDX2, Ilist1 == Ilist2,
        	(Ext = {true},
			THA = (THB,THZ)
		;
			THA = ((Ext1,THB;[]),THZ),
			ext_w(Alist1,Ext,Ext1)),
		Head =.. [Hname|Args],
		length(Alist1,CCC), 
		(CCC == 0,
			ext_w(Alist1,LC,LCCC),
			A1 = [[HT,LCCC,'LCC|LC']]
		;
			ext_w(Alist1,Args,Args2),
			ext_w(Alist1,LC,LCCC),
			append(Args2,[[HT,LCCC,'LCC|LC']],A1)),
		THB =.. [Hname,'X'|A1],
		R = RRc,!
	;
		RRc = [(last,arg(Alist1),(IDX1,Ilist1),Head,EXT,Taa)|RRc1],
		last_eval(R,RRc1,arg(Alist2),(IDX2,Ilist2),(Term,C),Tp1,
			  THA,TH_last),!
	).

lastm_eval([],[],_,_,_,_,T,T) :- !.
lastm_eval([(last,A,B,C,D,E)|R],[(last,A,B,C,D,E)|RRc],
	arg(Alist),(IDX,Ilist),TermC,Tp1,T0,T1) :-
	lastm_eval(R,RRc,arg(Alist),(IDX,Ilist),TermC,Tp1,T0,T1),!.
lastm_eval([(middle,arg(Alist1),(IDX1,Ilist1),(ID2,Var2),EXT)|R],RRc,
	         arg(Alist2),(IDX2,Ilist2),(Term,C),Tp1,T0,TZ) :-
	(Alist1 == Alist2,IDX1 == IDX2, Ilist1 == Ilist2,
		(
        	(Ext = {true},
			T0 = ([THA],TZ)
		;
			ext_w(Alist1,EXT,Ext1),
			T0 = ((Ext1,[THA];[]),TZ)),
		length(Var2,C2),
		(C2 == 0,
			AAr = ['[LCC|LC]']
		;
			ext_w(Alist1,Var2,Var22),
			append(Var22,['[LCC|LC]'],AAr)),
		THA =.. [ID2,'X'|AAr],
		
		R = RRc,!
		)
	;
		RRc = [(middle,arg(Alist1),(IDX1,Ilist1),(ID2,Var2),EXT)|RRc1],
		lastm_eval(R,RRc1,arg(Alist2),(IDX2,Ilist2),
				(Term,C),Tp1,T0,TZ),!
	).


put_Public([A]) :- var(A),!.
put_Public(A) :- nl,write(':- public '),put_lpub(A),!.
put_lpub([A]) :-
	var(A),
	write('id_pair/2.'),nl,!.
put_lpub([A|R]) :- 
	write(A),write('/1,'),!,
	put_lpub(R).

link_memo(T,H) :- 
	functor(H,Head,_),
	link_memo1(T,Head).
link_memo1(C,C) :- !.
link_memo1(C1,C2) :-
 ( recorded(C1,C2,_) ;
   recordz(C1,C2,_),
      (	recorded(nonterm,C1,_);
	recordz(nonterm,C1,_) ) ),!.


put_link :-
   nl,
   mk_link,
   print_link,!.

mk_link :-
	recorded(nonterm,X,_),
	recorded(X,Y,_),
	recorded(Y,Z,_),
	X \== Z,
	already(X,Z),
	fail.
mk_link :- n_mk_link.

already(X,Z) :-
      (	recorded(X,Z,_) ;
	new_link_pair(X,Z) ;
	assertz(new_link_pair(X,Z)) ),!.

n_mk_link :-
	new_link_pair(X,Y),
	recorded(Y,Z,_),
	X \== Z,
	n_alrdy(X,Z),
	fail.
n_mk_link :-
	brand_new(_,_),!,
	copy_link,!,
	n_mk_link.
n_mk_link.

n_alrdy(X,Z) :-
      ( recorded(X,Z,_) ;
	new_link_pair(X,Z) ;
	brand_new(X,Z);
	assertz(brand_new(X,Z)) ),!.

copy_link :-
	new_link_pair(X,Y),
	recordz(X,Y,_),
	fail.
copy_link :-
	abolish(new_link_pair,2),
	brand_new(X,Y),
	assertz(new_link_pair(X,Y)),
	fail.
copy_link :-
	abolish(brand_new,2).

print_link :-
	copy_link,
	nl,write('link(X,X).'),nl,
	pr_links,
	recorded(nonterm,X,Ref),erase(Ref),
	recorded(X,Y,Ref1),erase(Ref1),
	functor(Term1,X,1),arg(1,Term1,Y),
	write(Term1),write('.'),nl,
	fail.
print_link.

pr_links :-
	recorded(nonterm,Term,_),
	functor(T,'link',2),arg(1,T,Term),arg(2,T,'X'),
	functor(TT,Term,1),arg(1,TT,'X'),
	A =.. [(:-),T,TT],
	write(A),write('.'),nl,
	fail.
pr_links :- nl.

check_x(L,Table):- check_xx(L,[],[],Table).
check_xx([],_,_,Table):- !. 
check_xx([H|T],F,A,Table):- functor(H,F,A),!,check_xx(T,F,A,Table).
check_xx([H|T],_,_,Table):- 
  functor(H,F,A),
  (not_find((F,A),Table),!,
   display(F),display('/'),display(A),nl;
  true),check_xx(T,F,A,Table).
not_find(_,V):- var(V),!.
not_find(NT,[[NT|_]|_]):- !,fail.
not_find(NT,[_|T]):- not_find(NT,T).
