%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (C)1992 Institute for New Generation Computer Technology %
% $BG[I[$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F2<$5$$(B          %
% ( Read COPYRIGHT for detailed information. )             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


print_LC_tree([A]) :- !,nl,
	eval_LC_TDRL(A,0).

eval_LC_TDRL([],_) :- !.
eval_LC_TDRL(A,Depth) :- 
	atomic(A),!,
	out_depth(Depth),
	write(A),nl.
eval_LC_TDRL([Cat,{E}|R],Depth) :- 
	out_depth(Depth),
	write(Cat),nl,
	eval_LC_TDRL(R,Depth).
eval_LC_TDRL([A|R],Depth) :-
	Depth1 is Depth + 1,
	eval_LC_TDRL(A,Depth1),!,
	eval_LC_TDRL(R,Depth).


eval_LCsRL([],_) :- !.
eval_LCsRL([Cat,{_}|R],Depth) :- 
	out_depth(Depth),
	write(Cat),nl,!,
	eval_LCsRL(R,Depth).
eval_LCsRL([LC|R],Depth) :-
	eval_LC_TDRL(LC,Depth),!,
	eval_LCsRL(R,Depth).

out_depth(0).
out_depth(N) :-
	write('   '),
	NN is N - 1,!,
	out_depth(NN).


eval_Ext(true) :- !.
eval_Ext((A,R)) :-
	call(A),!,
	eval_Ext(R).
eval_Ext(A) :-
	call(A).

