/*

	proof - An interactive proofreader

	Copyright (c) 1989, 1990-1 Craig Latta. All Rights Reserved.

	Permission to use, copy, and/or distribute for any purpose and
  without fee is hereby granted, provided that both the above copyright
  notice and this permission notice appear in all copies and derived works.
  Fees for distribution or use of this software or derived works may only
  be charged with express written permission of the copyright holder.
  This software is provided ``as is'' without express or implied warranty.
	
	FILE:		proof.h

	DESCRIPTION:	The header of the left-associative parser used
	                to check grammar in proof.

*/

/* Global constants */

#define BUFFER_LEN      256
#define CAT_BUFFER      -2      /* delimits categorizations in the lexica */
#define END             -1      /* terminator for segment, category lists */

#define KEY_LEN         50      /* database keysize in bytes (?)       */
#define MAX_CATEGORIES  10      /* maximum number of grammatically correct
				   interpretations of a sentence       */
#define MAX_DERIVATIONS 20      /* could be too low */
#define	MAX_SEGMENTS	10	/* maximum number of segments          
				   possessed by a lexical entry.       */
#define MAX_LEN         30

#define MAX_COMMANDS    10      /* maximum number of commands */
				/* allowable in a single pass */

#define NUM_RULES       50
#define SURFACE_LEN     100    
#define START_HASH_LEN  1024    /* initial internal hash table size    */

#define NOMERGE         0
#define MERGE           1

#define NOQUERY         0
#define QUERY           1

#define SOME            0
#define ALL             1

typedef enum condition
{
  INVALID, INV_UNKNOWN, INV_LONG, VALID, VA_NEW
} CONDITION;


/* macros */


/* segment tokens */

/* add new segments to the end, to avoid trashing the existing dictionary! */
typedef enum segment
  {
    NOSEG, A, AG, B, C, __C, CA, _CA, CH, C_H, _CH, _C_H, D, DECL, DO,
    HV, INTERROG, M, N, NM, NOM, NP, P, P1, P3, OB_P3, PH, OB_PH, P_H,
    PNM, S, S1, S3, SC, SH, OB_SH, S_H, TO, U, V, VI, WH, OB_WH,
    W_H, WP, WS, WU, OB, AV, OB_S1, OB_S3, OB_P1, SD
  } SEG;


/* package tokens */

typedef enum rule
  {
    NORULE, ADD_MINUS_NOM, ADD_MINUS_VERB, COMPLETE, DET_PLUS_ADJ,
    DET_PLUS_NOUN, DONE, FVERB_PLUS_MAIN, FVERB_PLUS_NOM, 
    NOM_PLUS_FVERB, NOUN_PLUS_PNM, NOM_PLUS_RELPRO, PREP_PLUS_NP, START,
    START_MINUS_RELCL, START_MINUS_SUBCL, TOP_MINUS_MAIN, WH_PLUS_VERB
  } RULE;


/* Types */

typedef char      BUFFER[BUFFER_LEN];
typedef SEG       CATEGORY[MAX_SEGMENTS];
typedef CATEGORY  DEFINITION[MAX_CATEGORIES];
typedef char      SURFACE[SURFACE_LEN];


/* Structures */

typedef struct _LEXENTRY
{
  /* 
   *  segments[0][0] = number of categorizations, excluding segments[0]
   *  segments[n][0] = length of categorization n, excluding this cell
   */
  CATEGORY  segments[MAX_CATEGORIES];
  SURFACE   surface;
} LEXENTRY;

typedef struct _STATE
{
  LEXENTRY  *start;
  char      *rest;
} STATE;

typedef struct _HISTENTRY
{
  RULE       rules[NUM_RULES];
  SURFACE    start, next, rest;
  CATEGORY   segments[MAX_CATEGORIES];
} HISTENTRY;


/* Project-global variables */

extern char       error[BUFFER_LEN];
extern HISTENTRY  *history;
extern int        backtracked, curr_deriv;
extern CONDITION  curr_condition;  /* condition code for the current */
				   /* sentence start */


/* Prototypes by module, generated by XSaber-C 3.0 beta */

/* module: /usr/users/latta/projects/xcf/proof/src/motor.c */

void comb_definition(enum segment (*)[10]);
void compact_category(enum segment *, int);
void compact_definition(enum segment (*)[10], int);
int compare_categories(enum segment *, enum segment *);
void copy_category(enum segment *, enum segment *);
void copy_segments(enum segment (*)[10], enum segment (*)[10]);
datum *define_word(char *, int, int);
void display_segments(enum segment (*)[10]);
struct _STATE *expand(char *);
void get_first_surface(char *, char *);
char *get_last_surface(char *);
struct _LEXENTRY *get_next_word(char *);
void print_status(struct _LEXENTRY *, struct _LEXENTRY *);
void read_it(struct _STATE *);
int splice_category(enum segment *, int, enum segment *);
int undefine_word(char *, int);
void unpack(char *, struct _LEXENTRY *);
void main(int, char *[]);
   
/* module: /usr/users/latta/projects/xcf/proof/src/rules.c */

void combine(struct _LEXENTRY *, struct _LEXENTRY *);
void p_add_minus_nom(struct _LEXENTRY *, struct _LEXENTRY *);
void p_add_minus_verb(struct _LEXENTRY *, struct _LEXENTRY *);
void p_det_plus_adj(struct _LEXENTRY *, struct _LEXENTRY *);
void p_det_plus_noun(struct _LEXENTRY *, struct _LEXENTRY *);
void p_fverb_plus_main(struct _LEXENTRY *, struct _LEXENTRY *);
void p_fverb_plus_nom(struct _LEXENTRY *, struct _LEXENTRY *);
void p_nom_plus_fverb(struct _LEXENTRY *, struct _LEXENTRY *);
void p_nom_plus_relpro(struct _LEXENTRY *, struct _LEXENTRY *);
void p_prep_plus_np(struct _LEXENTRY *, struct _LEXENTRY *);
void p_noun_plus_pnm(struct _LEXENTRY *, struct _LEXENTRY *);
void p_top_minus_main(struct _LEXENTRY *, struct _LEXENTRY *);
void p_start(struct _LEXENTRY *, struct _LEXENTRY *);
void p_start_minus_relcl(struct _LEXENTRY *, struct _LEXENTRY *);
void p_start_minus_subcl(struct _LEXENTRY *, struct _LEXENTRY *);
void p_wh_plus_verb(struct _LEXENTRY *, struct _LEXENTRY *);
void r_add_minus_nom(struct _LEXENTRY *, struct _LEXENTRY *);
void r_add_minus_verb(struct _LEXENTRY *, struct _LEXENTRY *);
void r_complete(struct _LEXENTRY *, struct _LEXENTRY *);
void r_det_plus_adj(struct _LEXENTRY *, struct _LEXENTRY *);
void r_det_plus_noun(struct _LEXENTRY *, struct _LEXENTRY *);
void r_fverb_plus_main(struct _LEXENTRY *, struct _LEXENTRY *);
void r_fverb_plus_nom(struct _LEXENTRY *, struct _LEXENTRY *);
void r_nom_plus_fverb(struct _LEXENTRY *, struct _LEXENTRY *);
void r_noun_plus_pnm(struct _LEXENTRY *, struct _LEXENTRY *);
void r_nom_plus_relpro(struct _LEXENTRY *, struct _LEXENTRY *);
void r_prep_plus_np(struct _LEXENTRY *, struct _LEXENTRY *);
void r_start_minus_relcl(struct _LEXENTRY *, struct _LEXENTRY *);
void r_start_minus_subcl(struct _LEXENTRY *, struct _LEXENTRY *);
void r_top_minus_main(struct _LEXENTRY *, struct _LEXENTRY *);
void r_wh_plus_verb(struct _LEXENTRY *, struct _LEXENTRY *);
