:-mode
interpret(?,?),
get_word(-,-,-,-,-),
get_ending_type(-,-,-),
ending_type(-,-,-),
actual_endings(-,-),
word(-,-,-,-,-),
get_actual_endings2(?,?).

:-public
interpret/2,
get_word/5,
get_ending_type/3,
get_actual_endings2/2,
ending_type/3,
actual_endings/2,
word/5.

:-external
ending_type/3,
actual_endings/2.

/* *************************************************************
1/88 - to go with Linger shell.

   interpret(+,-)
   will input either a list of strings
	             a list of strings and atoms
   and will output the corresponding akii list in the second
   parameter
*************************************************************** */

interpret([],[]):-!.

interpret([H|T],[H|X]):-
     atom(H),!,
     interpret(T,X).

interpret([H|T],[List|X]):-
     string(H),!,
     list(List,H),!,
     interpret(T,X).

interpret([[H]|T],[List|X]):-
     string(H),!,
     list(List,H),!,
     interpret(T,X).

interpret(X,List):-
     string(X),!,
     list(List,X).

interpret(X,X):-!. /* fall through for atoms only */

get_word(String,String_list,Atom,String_atom,Atom_string):-
              word(A,B,Atom,C,D),
              interpret(A,String),
              interpret(B,String_list),
              interpret(C,String_atom),
              interpret(D,Atom_string).

get_ending_type(Atom,List_string,Atom2):-
              ending_type(Atom,B,Atom2),
              interpret(B,List_string).

get_actual_endings2(Atom,List_string):-
              actual_endings(Atom,B),
              interpret(B,List_string).


