/*  GERMAN  DICTIONARY  */
/*  10 . 3 . 86 .       */                


/*
NOUNS
*/

info(noun,[[plurality(s)],[plurality(p)]],[gender],[person(3)]).

word("",["bank"],noun,["","en"],[f]).
word("",["bett"],noun,["","en"],[n]).
word("",["boot"],noun,["","e"],[n]).
word("buch",[""],noun,["buch","buecher"],[n]).
word("",["frau"],noun,["","en"],[f]).
word("haus",[""],noun,["haus","haeuser"],[n]).
word("",["hund"],noun,["","e"],[m]).
word("",["kaninchen"],noun,["",""],[n]).
word("",["katz"],noun,["e","en"],[f]).
word("",["kind"],noun,["","er"],[n]).
word("",["kueche"],noun,["","n"],[f]).
word("",["maedchen"],noun,["",""],[n]).
word("mann",[""],noun,["mann","maenner"],[m]).
word("mutter",[""],noun,["mutter","muetter"],[f]).
word("",["pferd"],noun,["","e"],[n]).
word("",["schule"],noun,["","n"],[f]).
word("stadt",[""],noun,["stadt","staedte"],[f]).
word("",["strasse"],noun,["","n"],[f]).
word("stuhl",[""],noun,["stuhl","stuehler"],[m]).
word("vater",[""],noun,["vater","vaeter"],[m]).
word("zug",[""],noun,["zug","zuege"],[m]).


/*
PRONOUNS
*/

info(pronoun,[[case(nom)],[case(acc)],[case(dat)]],[person,plu
rality,gender],[]).

word("ich",[""],pronoun,["ich","mich","mir"],[1,s,any]).
word("du",[""],pronoun,["du","dich","dir"],[2,s,any]).
word("Sie",[""],pronoun,["Sie","Sie","Ihnen"],[2,s,any]).
word("er",[""],pronoun,["er","ihn","ihm"],[3,s,m]).
word("sie",[""],pronoun,["sie","sie","ihr"],[3,s,f]).
word("es",[""],pronoun,["es","es","ihm"],[3,s,n]).
word("wir",[""],pronoun,["wir","uns","uns"],[1,p,any]).
word("ihr",[""],pronoun,["ihr","euch","euch"],[2,p,any]).
word("Sie",[""],pronoun,["Sie","Sie","Ihnen"],[2,p,any]).
word("sie",[""],pronoun,["sie","sie","ihnen"],[3,p,any]).


/*
ADJECTIVES
*/

info(adjective,[type],[],[]).
word("",["alt"],adjective,adj_end,[]).
word("",["gross"],adjective,adj_end,[]).
word("",["interessant"],adjective,adj_end,[]).
word("",["jung"],adjective,adj_end,[]).
word("",["klein"],adjective,adj_end,[]).
word("",["schwarz"],adjective,adj_end,[]).
word("",["weiss"],adjective,adj_end,[]).


/*
ADJECTIVE  ENDINGS
*/

info(adj_end,[
[gender(m),plurality(s)],[gender(f),plurality(s)],[gender(n),
plurality(s)],[gender(any),plurality(p)] ],[case,used_with],[]).

ending_type(adj_end,["er","e","es","e"],[nom,no_art]).
ending_type(adj_end,["en","e","es","e"],[acc,no_art]).
ending_type(adj_end,["es","er","es","er"],[gen,no_art]).
ending_type(adj_end,["em","er","em","en"],[dat,no_art]).
ending_type(adj_end,["e","e","e","en"],[nom,def_art]).
ending_type(adj_end,["en","e","e","en"],[acc,def_art]).
ending_type(adj_end,["en","en","en","en"],[gen,def_art]).
ending_type(adj_end,["en","en","en","en"],[dat,def_art]).
ending_type(adj_end,["er","e","es","en"],[nom,indef_art]).
ending_type(adj_end,["en","e","es","en"],[acc,indef_art]).
ending_type(adj_end,["en","en","en","en"],[gen,indef_art]).
ending_type(adj_end,["en","en","en","en"],[dat,indef_art]).


/*
DETERMINERS
*/

info(definite_article,[type],[],[]).

word("der",["d"],definite_article,def_art_end,[]).
word("jeder",["jed"],definite_article,def_art_end,[]).
word("jener",["jen"],definite_article,def_art_end,[]).

info(indefinite_article,[type],[],[]).

word("ein",["ein"],indefinite_article,indef_art_end,[]).
word("kein",["kein"],indefinite_article,indef_art_end2,[]).


/*
DETERMINER ENDINGS
*/

info(def_art_end,[
[gender(m),plurality(s)],[gender(f),plurality(s)],[gender(n),
plurality(s)],[gender(any),plurality(p)] ],[case],[]).

ending_type(def_art_end,["er","ie","as","ie"],[nom]).
ending_type(def_art_end,["en","ie","as","ie"],[acc]).
ending_type(def_art_end,["es","er","es","er"],[gen]).
ending_type(def_art_end,["em","er","em","en"],[dat]).

info(indef_art_end,[
[gender(m),plurality(s)],[gender(f),plurality(s)],[gender(n),
plurality(s)] ],[case],[]).

ending_type(indef_art_end,["","e",""],[nom]).
ending_type(indef_art_end,["en","e",""],[acc]).
ending_type(indef_art_end,["es","er","es"],[gen]).
ending_type(indef_art_end,["em","er","em"],[dat]).

info(indef_art_end2,[
[gender(m),plurality(s)],[gender(f),plurality(s)],[gender(n),
plurality(s)],[gender(any),plurality(p)] ],[case],[]).

ending_type(indef_art_end2,["","e","","e"],[nom]).
ending_type(indef_art_end2,["en","e","","e"],[acc]).
ending_type(indef_art_end2,["es","er","es","er"],[gen]).
ending_type(indef_art_end2,["em","er","em","en"],[dat]).


/*
AUXILIARY  VERBS
*/

info(aux_verb,[[person(1),plurality(s)],[person(2),
plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),
plurality(p)] ],[tense,transitivity,motion,modal],[]).                      

word("haben",[""],aux_verb,["habe","hast","hat","haben",
"haben","haben"],[present,t,n,n]).
word("sein",[""],aux_verb,["bin",
"bist","ist","sind","sind","sind"],[present,i,n,n]).


/*
VERBS
*/

info(verb,[type],[transitivity,motion,modal],[]).

word("fahren",["fahr","faehr"],verb,verb_end2,[i,y,n]).
word("geben",["geb","gib"],verb,verb_end2,[t,n,n]).
word("gehen",["geh"],verb,verb_end,[i,y,n]).
word("kommen",["komm"],verb,verb_end,[i,n,n]).
word("lesen",["les","lies"],verb,verb_end,[t,n,n]).
word("lieben",["lieb"],verb,verb_end,[t,n,n]).
word("liegen",["lieg"],verb,verb_end,[i,n,n]).
word("machen",["mach"],verb,verb_end,[t,n,n]).
word("muessen",["muess","muss"],verb,verb_end5,[i,n,y]).
word("sitzen",["sitz"],verb,verb_end3,[i,n,n]).
word("werden",["werd","wir"],verb,verb_end4,[i,n,y]).


/*
VERB ENDINGS
*/

info(verb_end,[
[person(1),plurality(s)],[person(2),plurality(s)],[person(3),
plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),
plurality(p)] ],[tense],[]).

ending_type(verb_end,["e","st","t","en","en","en"],[present]).

info(verb_end2,[
[person(1),plurality(s)],[person(2),plurality(s),root(2)],
[person(3),plurality(s),root(2)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),
plurality(p)] ],[tense],[]).

ending_type(verb_end2,["e","st","t","en","en","en"],[present]).

info(verb_end3,[
[person(1),plurality(s)],[person(2),plurality(s)],[person(3),
plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),
plurality(p)] ],[tense],[]).

ending_type(verb_end3,["e","t","t","en","en","en"],[present]).

info(verb_end4,[
[person(1),plurality(s)],[person(2),plurality(s),root(2)],
[person(3),plurality(s),root(2)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),
plurality(p)] ],[tense],[]).

ending_type(verb_end4,["e","st","d","en","en","en"],[present]).

info(verb_end5,[
[person(1),plurality(s),root(2)],[person(2),plurality(s),root(
2)],[person(3),plurality(s),root(2)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),
plurality(p)] ],[tense],[]).

ending_type(verb_end5,["","t","","en","en","en"],[present]).

info(verb_end6,[
[person(1),plurality(s)],[person(2),plurality(s),root(2)],
[person(3),plurality(s),root(2)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),
plurality(p)] ],[tense],[]).

ending_type(verb_end6,["e","t","t","en","en","en"],[present]).


/*
PAST PARTICIPLES
*/

info(past_participle,[[]],[conjug_with,transitivity,motion,modal],[]).

word("gefahren",["gefahr"],past_participle,["en"],[sein,i,y,n]).
word("gegangen",["gegang"],past_participle,["en"],[sein,i,y,n]).
word("gegeben",["gegeb"],past_participle,["en"],[haben,t,n,n]).
word("gekommen",["gekomm"],past_participle,["en"],[sein,i,n,n]).
word("gelegen",["geleg"],past_participle,["en"],[haben,i,n,n]).
word("gelesen",["geles"],past_participle,["en"],[haben,t,n,n]).
word("geliebt",["gelieb"],past_participle,["t"],[haben,t,n,n]).
word("gemacht",["gemach"],past_participle,["t"],[haben,t,n,n]).
word("gemusst",["gemuss"],past_participle,["t"],[haben,t,n,y]).
word("gesessen",["gesess"],past_participle,["en"],[haben,i,n,n]).
word("geworden",["geword"],past_participle,["en"],[haben,i,n,y]).


/*
INFINITIVES
*/

info(infinitive,[],[transitivity,motion,modal],[]).

word("",["fahren"],infinitive,[],[i,y,n]).
word("",["geben"],infinitive,[],[t,n,n]).
word("",["gehen"],infinitive,[],[i,y,n]).
word("",["kommen"],infinitive,[],[i,n,n]).
word("",["lesen"],infinitive,[],[t,n,n]).
word("",["lieben"],infinitive,[],[t,n,n]).
word("",["liegen"],infinitive,[],[i,n,n]).
word("",["machen"],infinitive,[],[t,n,n]).
word("",["mussen"],infinitive,[],[i,n,y]).
word("",["sitzen"],infiitive,[],[i,n,n]).
word("",["werden"],infinitive,[],[i,n,y]).


/*
PREPOSITIONS
*/

info(preposition,[],[could_take_acc],[]).

word("",["in"],preposition,[],[y]).
word("",["auf"],preposition,[],[y]).
word("",["aus"],preposition,[],[n]).
word("",["mit"],preposition,[],[n]).


/*
GUESS CLASS
*/

open(noun).
open(adjective).
open(adverb).
open(verb).
open(past_participle).
open(infinitive).

insert_type(noun).
insert_type(adjective).
insert_type(adverb).
insert_type(verb).
insert_type(past_participle).
insert_type(infinitive).
insert_type(definite_article).
insert_type(indefinite_article).
insert_type(preposition).
insert_type(pronoun).
insert_type(aux_verb).
