/* DEBUG.PL  */


/* what_assert - prints what has been asserted in "found" */

what_assert:-
    found(X,C,V,B,N,M,J,K,A),
    write('(atom = '),write(X),
    write(', list word = '),write(C),
    write(', ref word = '),write(V),
    write(', type = '),write(B),
    write(', root found = '),write(N),
    write(', ending = '),write(M),
    write(', endings = '),write(J),
    write(', infos = '),write(K),
    write(', word pos = '),write(A),write(')'),nl,
           fail.
what_assert.

/* test_type_list - takes in list and states what type is in list */

test_type_list(H):-
    is_string_list(H),
    write(' List of strings -- '),
nl, write(H),nl.

test_type_list(H):-
    is_atom_list(H),
    write(' List of atoms -- '),
nl, write(H),nl.

test_type_list(H):-
    write(' god knows what its a list of -- '),
nl, write(H),nl.

is_atom_list([H|T]):-
    atom(H),
    is_atom_list(T).

is_atom_list([]).


is_string_list([H|T]):-
    string(H),
    is_string_list(T).

is_string_list([]).

/* Space savers - only use if necessary, takes time! */

tidy:-trimcore.


writedb([]):-nl.
writedb([H|T]):-
               write(H),
               writedb(T).


write_all_trees:-
    tree(_,Tree),
    write_tree(Tree),
    fail.

write_all_trees.
what_in_db:-
            found(A,B,C,D,E,F,G,H,I),
            writedb(['found = ', A, ' ', B, ' ', C, ' ', D, ' ', E, ' ', F,'',
            G,' ',H,' ',I]),nl,
            possibility(J,K,L,M,N,O,P,Q),
            writedb(['possib = ', J, ' ', K, ' ', L, ' ', M, ' ', N,'',
            O,' ',P,' ',Q]),nl,
            fail.

what_in_db:-!.

/* to stop duplication in db - esp. re. found and possibilities */

assert_once_into_db(A):-
    call(A),
    !,
    fail.

assert_once_into_db(A):-
    assertz(A).
