/* File: smallgram.pl
 * Created: 22-Nov-93
 * Last Update:  7-Dec-93
 * Author: Afzal Ballim
 * Purpose: a small lhip grammar
 * Needs: lhip
 */


s(conjunction(Conj,P,Q))
~~>
	s(P),
	*conjunct(Conj),
	s(Q).

s(if(P,Q))
~~>
	* @if,
	s(P),
	* @then,
	s(Q).

s(npvp(NP,VP))
~~>
	np(NP),
	*vp(VP).

vp(vp(V))
~~>
	iv(V).

vp(vp(V,NP))
~~>
	*tv(V),
	np(NP).

vp(vp(V,NP1,NP2))
~~>
	*datv(V),
	np(NP1),
	np(NP2).

iv(returned) ~~> @returned.

tv(saw)	 ~~> @saw.
tv(shot) ~~> @shot.

datv(gave) ~~> @gave.

np(conj(NP1,NP2,Conj))
~~>
	np(NP1),
	*npconjunct(Conj),
	np(NP2).

np(proper(N,Mods)) 
~~>
	~ det(_),
	(? adjectives(Mods) ?),
	*noun(N).

np(np(N,Det,Mods))
~~>
	det(Det),
	-eh,
	(? adjectives(Mods) ?),
	*noun(N).
	
det(the) ~~> @the.

det(a) ~~> @a.

noun(mark) ~~> @mark.

noun(john) ~~> @john.

noun(mary) ~~> @mary.

noun(gun)  ~~> @gun.

noun(it)   ~~> @it.

noun(ball) ~~> @ball.

noun(X) ~~> 
		(? @bunny ?):
		@rabbit,
		{X=rabbit}.

noun(X) ~~> 
		( * @pussy: (? @cat ?);
		  * @cat
		),
			{X=cat}.

adjectives([A|As]) # 0.75
~~> 
	adjective(A),
	adjectives(As).

adjectives([A]) ~~> adjective(A).

adjective(big)		~~> @big.
adjective(small)	~~> @small.
adjective(red)		~~> @red.

conjunct(but)		~~> @but.
conjunct(so)		~~> @so.
conjunct(although)	~~> @although.
conjunct(as)		~~> @as.
conjunct(because)	~~> @because.
conjunct(C)			~~> npconjunct(C).

npconjunct(and)		~~> @and.
npconjunct(or)		~~> @or.

-hmm ~~>  @hmm.
-eh ~~> @eh.
