%
% ProTcl 1.1
%
%	Definitions common to all Prologs
%
% Author: Micha Meier
% Minor changes by Gertjan van Noord         94/05/13
%
% sccsid("@(#)tk_common.pl	1.5          94/01/25").
% sccscr("@(#)  Copyright 1993 ECRC GmbH ").
%

tk_demo :-
    tk_init('$tk_library/demos/widget', []),
    tcl_eval('source $tk_library/demos/widget'),
    tcl_eval(update),
    tk_main_loop.

tk_test :-
    tk([]),
    tk_lib(S),
    concat_atoms('cd ', S, CDS),
    concat_atoms(CDS, '/tests', CDT),
    tcl_eval(CDT),
    tcl_eval('source all'),
    tcl_eval('exit').

tk_init(File, Opts) :-
    tk_options(Opts),
    tk_init(File),
    tk_lib(Tk),
    tcl_lib(Tcl),
    concat_atoms('global tcl_library; set tcl_library ', Tcl, TclCmd),
    concat_atoms('set tk_library ',Tk,TkCmd),
    tcl_eval(TclCmd),
    tcl_eval(TkCmd),
    tcl_eval('source $tcl_library/init.tcl'),
    tcl_eval('source $tk_library/tk.tcl').

tk_options([]).
tk_options([Opt|List]) :-
    Opt =.. [Name|Args],
    (Args = [Val|_] ->
	true
    ;
	Val = ''
    ),
    tk_option(Name, Val),
    tk_options(List).

tk_file(File, Options) :-
    tk_init(File, Options),
    concat_atoms('source ', File, InitFile),
    tcl_eval(InitFile),
    tcl_eval(update),
    tk_main_loop.

tk_main_loop :-
    tk_do_one_event(0),
    tk_num_main_windows(X), X > 0 ->
	tk_main_loop
    ;
	true.

