%%%%%%%%%%%%%%%%%
% prettyvars.pl %
%%%%%%%%%%%%%%%%%

% adapted from Sicstus/Library/write.pl

:- module(prettyvars,[ prettyvars/1, 
	               prettyvars/3,
		       un_prettyvars/2]).

:- use_module( library(lists), [ member/2 ]).

% un_prettyvars(+Term) melts a term with $VAR back into ordinary ones

un_prettyvars(Term0,Term) :-
	un_prettyvars(Term0,Term,_).

un_prettyvars(Var0,Var,_) :-
	var(Var0),!,
	Var0=Var.
un_prettyvars('$VAR'(No),Var,Done) :-
	!,
	un_prettyvar(No,Var,Done).

un_prettyvars(Term0,Term,Done) :-
	functor(Term0,F,A),
	functor(Term, F,A),
	un_prettyvars(A,Term0,Term,Done).

un_prettyvars(0,_,_,_) :-
	!.
un_prettyvars(I,T0,T,D) :-
	arg(I,T0,A0),
	arg(I,T, A ),
	un_prettyvars(A0,A,D),
	I2 is I-1,
	un_prettyvars(I2,T0,T,D).

un_prettyvar('_',_,_) :-!.
un_prettyvar(N,V,D) :-
	member(N/V,D),!.

prettyvars(Term) :-
	prettyvars(Term,0,_).

prettyvars(Term,I0,I) :-
	prettyvars0(Term, Vars0, []),    % collect vars
	keysort(Vars0, Vars),            % then you only need to compare neighbors
	set_singleton_vars(Vars, I0, I). % to find out about singletion-vars

prettyvars0(Var) -->
	{var(Var)}, !, [Var-[]].
prettyvars0([X|Xs]) --> !,
	prettyvars0(X),
	prettyvars0(Xs).
prettyvars0(X) -->
	{functor(X, _, A)},
	prettyvars0(0, A, X).

prettyvars0(A, A, _) --> !.
prettyvars0(A0, A, X) -->
	{A1 is A0+1},
	{arg(A1, X, X1)},
	prettyvars0(X1),
	prettyvars0(A1, A, X).

set_singleton_vars([], No, No).
set_singleton_vars([X,Y|Xs], N0,N) :-
	X==Y, !,
	X='$VAR'(N0)-[],
	N1 is N0+1,
	set_singleton_vars(Xs, X, N1, N).
set_singleton_vars(['$VAR'('_')-[]|Xs], N0,N) :-
	set_singleton_vars(Xs, N0,N).

set_singleton_vars([X|Xs], Y, N0,N) :-
	X==Y, !,
	set_singleton_vars(Xs, Y, N0,N).
set_singleton_vars(Xs, _, N0,N) :-
	set_singleton_vars(Xs, N0,N).


