%%%%%%%%%%%%%%%%%%%%%%
% partial evaluation %
%%%%%%%%%%%%%%%%%%%%%%

:- use_module([library(term_expand),
	       library(link_clause)]).

partial(H,Ds0,H,Ds) :-
	partial(Ds0,Ds).

partial([],[]):-
    !.
partial([H|T],Res):-
    part1(H,R,Res),
    partial(T,R).

part1(Var,R,[Var|R]):-
    var(Var),!.
part1(C,R,Res):-
    !,
    part2(C,R,Res).
part1(A,R,[A|R]).

part2(Var,R,[Var|R]):-
    var(Var),
    !.
part2((A,B),R,Res):-
    !,
    part2(A,T,Res),
    part2(B,R,T).

:- op(900,fx,#).       % prefix for calls that are to be partially

part2(# Call,R,Body):-
    !,
    if( Call,
	R=Body,
	Body=[Call|R]
      ).
part2(C,R,Body):-
    functor(C,F,A),
    partial_executable(F/A),
    predicate_property(C,_),   
    !,
    if( C,
	R=Body,
	Body=[C|R]
      ).
part2(C,R,[C|R]).


add_partial(P) :-
	add_linking_clause(P,partial_executable,1).

del_partial(P) :-
	del_linking_clause(P,partial_executable,1).

:- add_expansion(partial).

