:- module(gen_sym, [gen_sym/1,
                    gen_sym/2,
		    gen_atom/1
		   ]).


:- use_module( library(concat), [ concat/3 ]).

% gen_sym(-Atom)

gen_sym(Atom) :-
	(  recorded(gen_sym,Integer,Ref)
        -> number_chars(Integer,Chars),
           atom_chars(Atom,Chars),
	   erase(Ref),
	   Integer2 is Integer + 1,
	   recordz(gen_sym,Integer2,_)
        ;  recordz(gen_sym,1,_),
	   Atom = '0'
        ).

%gen_sym(-Sym,+Prefix) 
gen_sym(Sym,Prefix) :-
	(  recorded(gen_sym,Prefix/Integer,Ref)
        -> number_chars(Integer,Chars),
           atom_chars(Atom,Chars),
	   erase(Ref),
	   Integer2 is Integer + 1,
	   concat(Prefix,Atom,Sym),
	   recordz(gen_sym,Prefix/Integer2,_)
        ;  concat(Prefix,'0',Sym),
	   recordz(gen_sym,Prefix/1,_)
        ).




gen_atom(Atom) :-
	(  recorded(gen_atom,Str,Ref)
        -> erase(Ref)
        ;  Str = [97]
        ),
	add1(Str,Str2),
	recordz(gen_atom,Str2,_),
	name(Atom0,Str),
	concat(plcmd,Atom0,Atom).

add1(L0,L) :-
	add1(L0,L1,Rest),
	( Rest =:= 0 -> L1 = L ; L = [97|L1]).

add1([],[],1).
add1([H|T],[NH|NT],Rest) :-
	add1(T,NT,Rest0),
	( Rest0 =:= 0 -> H = NH, Rest = 0 
        ; H2 is H + 1,
          ( H2 > 122 -> NH is 97, Rest = 1
          ; NH = H2, Rest=0 ) ).




	
