:- module(concat,
	[ concat/3,
	  concat_all/2,
	  concat_all/3,
	  term_atom/2,
	  term_atom/3,
	  atom_term/2
	]).

:- use_module( library(charsio), [ format_to_chars/3,
	                           read_from_chars/2 ]).
:- use_module( library(lists),   [ append/3          ]).

atom_term(Atom,Term) :-
	name(Atom,Chars0),
	append(Chars0,[46],Chars),
	read_from_chars(Chars,Term).

term_atom(Term,Atom) :-
	format_to_chars('~w',[Term],Chars),
	name(Atom,Chars).

term_atom(Term,Atom,Length) :-
	format_to_chars('~w',[Term],Chars),
	length(Chars,Length),
	name(Atom,Chars).

concat(Sym1,Sym2,Sym) :-
	nonvar(Sym1),
	nonvar(Sym2),
	!,
	name(Sym1,Str1),
	name(Sym2,Str2),
	append(Str1,Str2,Str),
	name(Sym,Str).

concat(Sym1,Sym2,Sym) :-
	nonvar(Sym1),
	nonvar(Sym),
	!,
	name(Sym1,Str1),
	name(Sym,Str),
	append(Str1,Str2,Str),
	name(Sym2,Str2).

concat(Sym1,Sym2,Sym) :-
	nonvar(Sym),
	nonvar(Sym2),
	!,
	name(Sym,Str),
	name(Sym2,Str2),
	append(Str1,Str2,Str),
	name(Sym1,Str1).

% concat_all(?ListofAtoms,?Atom,?Seperator)
% adds spaces between
% tail recursive, indexing (lessons by O'Keefe).

concat_all(List,Atom) :-
	concat_all(List,Atom,'').

concat_all([H|T],Result,Sep):-
	concat_all(T,H,'',Result,Sep).
concat_all([],'',_Sep).

%% :- block concat_all(-,?,?,?,?).
concat_all([],H,In,InH,_Sep):-
	concat(In,H,InH).
concat_all([F|T],H,In,Out,Sep):-
	concat(H,Sep,Ha),
	concat(In,Ha,In2),
	concat_all(T,F,In2,Out,Sep).










