:- module(between, [
	between/3,
	between/4
   ]).

%   between(+Lower, +Upper, ?Number)
%   is true when Lower, Upper, and Number are integers,
%   and Lower =< Number =< Upper.  If Lower and Upper are given,
%   Number can be tested or enumerated.  If either Lower or Upper
%   is absent, there is not enough information to find it, hence
%   failure.
%   Numbers are generated in ascending order. If you want descending
%   order, use between/4.

between(Edge1,Edge2,I) :-
	integer(Edge1),
	integer(Edge2),
	Edge1 =< Edge2, 
	between(Edge1,Edge2,I,+).

% between/4 as between/3, except that the fourth argument ('-' or
% '+') indicates whether integers are generated in descending or
% ascending order
between(Lower,Upper,I,Dir) :-
	(  integer(I) 
	-> Lower =< I, I =< Upper 
	;  between1(Dir,Lower,Upper,I) 
	).

%%  between1(Dir,Lower, Upper, Point)
%   enumerates values of Point satisfying Lower =< Point =< Upper,
%   where it is already known that Lower =< Upper and Point was a
%   variable.  Dir is an atom ('-' or '+') indicating whether the
%   integers are generated in descending or ascending order.

between1(+,L, U, L) :- 
	L =< U.
between1(+,L, U, N) :- 
	L < U,
	M is L+1,
	between1(+,M, U, N).
between1(-,L, U, U) :- 
	L =< U.
between1(-,L, U, N) :- 
	U > L,
	M is U-1,
	between1(-,L, M, N).


