# withdraw . until we've built everything
wm withdraw .
# make it resizable, with decent minimum sizes
wm minsize . 300 100

# envVal envValName
#   Looks up the envValName environment variable and returns its
#   value, or {} if it does not exists
proc envVal {envValName} {
  global env
  if [info exists env($envValName)] {return $env($envValName)} {return {}}
}

# loadAppDefaults classNameList ?priority?
#   Searches for the app-default files corresponding to classNames in
#   the order specified by X Toolkit Intrinsics, and loads them with
#   the priority specified (default: startupFile).
proc loadAppDefaults {classNameList {priority startupFile}} {
  set filepath "[split [envVal XUSERFILESEARCHPATH] :] \
                [envVal XAPPLRESDIR] \
                [split [envVal XFILESEARCHPATH] :] \
		/usr/local/lib/X11/app-defaults \
                /usr/lib/X11/app-defaults"
  foreach i $classNameList {
    foreach j $filepath {
      if {[file exists $j/$i]} {
        option readfile $j/$i $priority
        puts "loaded $j/$i"
        break
      }
    }
  }
}

wm geometry . +90+30

loadAppDefaults {SP_menu} 100

# Procedures that are needed in the rest of this file (i.e.
# directly upon sourcing this file, hence these must be at
# the top)

# PROC STEAL-SHELL
# large stdin/stdout shell (optional)
# Embedded xterm shell for ordinary prolog input/output
# updates are necc. otherwise error that parent window not is
# specified..
# the widthxheight depends on the size of xterm that you use
proc steal-shell {} {
    global steal
    # $steal indicates whether we actually should steal something
    # it is assumed that this variable is set before sourcing this
    # file
    global env
    global dir
    if $steal then {
        frame .shellbar
        frame .shell -width 840 -height 250
        pack .shellbar -fill x
        pack .shell
	# i don;t want to see the window at this moment, but I have
        # to make it visible for tksteal. For some windowmanagers
        # the following is a hack that makes it visible for tksteal
        # but invisible for the person sitting behind the terminal
        wm geometry . +10000+10000
        wm deiconify .
        update
	# steal it!
        xaccess eventreparent -window $env(WINDOWID) -parentwidget .shell
	# using tksteal command does not work

        # allow resizing of stolen window:
	button .shellbar.smaller -relief raised -bitmap @$dir/left.bm -command {
	 .shell configure -width \
                [expr [lindex [.shell configure -width] 4]-50]
        }
	button .shellbar.wider -relief raised -bitmap @$dir/right.bm -command {
	 .shell configure -width \
                [expr [lindex [.shell configure -width] 4]+50]
        }
	button .shellbar.higher -relief raised -bitmap @$dir/down.bm -command {
	 .shell configure -height \
                [expr [lindex [.shell configure -height] 4]+50]
        }
	button .shellbar.lower -relief raised -bitmap @$dir/up.bm -command {
	 .shell configure -height \
                [expr [lindex [.shell configure -height] 4]-50]
        }
	pack .shellbar.smaller .shellbar.lower .shellbar.higher \
             .shellbar.wider -side left
        # reset things
        wm withdraw .
	wm geometry . +90+30
    }
}

# SLAVES OF .

# menubar
frame .menu
pack .menu -side top -fill x

# buttonbar
frame .bb -bd 2 -relief raised 
## -height 25
pack .bb -fill x

# large scrollable canvas
frame .cv
pack .cv -fill both -expand 1

# optional shell window
steal-shell

# .t is a kind of status bar at the bottom of the window
# fill in whatever you like..
frame .t -relief raised
pack .t -side bottom -expand 0 -fill x

# end of slaves of .

canvas .cv.canvas -bd 2 -relief raised \
   -yscrollcommand ".cv.sy set" -xscrollcommand ".cv.sx set"\
   -scrollregion {-1c -1c 200c 100c}
## the large canvas has scrollbars
scrollbar .cv.sx -relief sunken -orient horiz -command ".cv.canvas xview"
scrollbar .cv.sy -relief sunken -command ".cv.canvas yview"

pack .cv.sx -side bottom -fill x
pack .cv.sy -side right -fill y
pack .cv.canvas -fill both -expand 1

## the large canvas can also be `scrolled' by dragging 2nd mouse button
bind .cv.canvas <2> ".cv.canvas scan mark %x %y"
bind .cv.canvas <B2-Motion> ".cv.canvas scan dragto %x %y"
## the large canvas is cleared with third mouse button
bind .cv.canvas <3> ".cv.canvas delete all"

## menubuttons for the menubar
menubutton .menu.file -text "File" -underline 0 -menu .menu.file.m
menu .menu.file.m

.menu.file.m add command -label "Compile" -underline 0 \
   -command {
            global fsBox
            set fsBox(pattern) *.pl
            FSBox {} {} {prolog "compile $fsBox(path)/$fsBox(name)" }
            set fsBox(pattern) *
}

.menu.file.m add command -label "Reconsult" -underline 0 \
   -command {
            global fsBox
            set fsBox(pattern) *.pl
            FSBox {} {} {prolog "reconsult $fsBox(path)/$fsBox(name)" }
	    set fsBox(pattern) *
}

.menu.file.m add command -label "Source TK/Tcl file" -underline 0 \
   -command {
            global fsBox
            set fsBox(pattern) *.tcl
            FSBox {} {} {source $fsBox(path)/$fsBox(name)}
            set fsBox(pattern) *
}

if !$steal then {
    .menu.file.m add command -label "Restart X" -underline 8 \
           -command {prolog restart_x}
}

if !$steal then {
    .menu.file.m add command -label "Restart X and steal the shell" \
           -underline 3 -command {prolog "restart_x 1"}
}

if !$steal then {
    .menu.file.m add command -label "Quit X (keep Prolog alive)" \
           -underline 0 -command {prolog halt_x}
}

.menu.file.m add command -label "Halt (both X and Prolog)" -underline 0 \
	-command exit_prolog
pack .menu.file -side left

menubutton .menu.debug -text "Debug" -underline 0 -menu .menu.debug.m
menu .menu.debug.m
.menu.debug.m add command -label "Nodebug" -underline 0 \
  -command {prolog nodebug}
.menu.debug.m add command -label "Debug" \
  -command {prolog debug} -underline 0
.menu.debug.m add command -label "Remove spypoints" \
  -command {prolog nospyall} -underline 0
.menu.debug.m add command -label "Spy predicate" -underline 0\
  -command {prolog "send_spy spy \
              [SP_question .g question {Predicate to spy:} {}]"}
.menu.debug.m add command -label "Unspy predicate" -underline 0 \
  -command {prolog "send_spy nospy \
              [SP_question .g question {Predicate to unspy:} {}]"}
.menu.debug.m add command -label "Memory statistics" \
  -command {prolog statistics} -underline 0
pack .menu.debug -side left

menubutton .menu.help -text "Help" -underline 0 -menu .menu.help.m
menu .menu.help.m
.menu.help.m add command -label "Help" -underline 0 \
   -command {prolog help}
.menu.help.m add command -label "About Tk Hdrug" -underline 6 \
   -command {
    global dir
    tk_dialog .d "About Tk Hdrug" \
        {All flames to vannoord@let.rug.nl (c) RUG 1994} \
        @$dir/vannoord.bm 0 {Seen enough?}
}
.menu.help.m add command -label "Version" -underline 0 \
   -command {prolog version}
pack .menu.help -side right

# Keyboard traversal thru menu
# Alt or Control does not work. Shift does work. But now
# you can simply use lowercase keys.. Not useful if you're in
# the shell window, of curse.
bind . <Any-FocusIn> {
    if {("%d" == "NotifyVirtual") && ("%m" == "NotifyNormal")} {
	focus .menu
    }
}

tk_menuBar .menu .menu.help .menu.file .menu.debug 

bind .menu <Key> {tk_traverseToMenu %W %A}
