%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 			                                  %
% written by Gertjan van Noord		                  %
% (C) 1988 1989 1990 1991 1992 1993                       %
%                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% CMD.PL  uses library/command.pl and defines extra (domain specific) predicates

:- ensure_loaded(library(command)).

:- use_module(library(lists), [ member/2 ]).
:- use_module(library(flags)).

:- del_command(env_cmd).

env_cmd((X,Y)) -->
        ['{'],
        env_cmd(X),
        [','],
        env_cmd(Y),
        ['}'].

env_cmd(compile_rules) -->
        [cr].

env_cmd(translate_obj(parse,Obj)) -->
        abbrev(parse,'*'),
	obj_spec(Obj).

env_cmd(go_l(KeyList)) -->
	[go],
	sequence_of_terms(KeyList,+).

env_cmd(go) -->
	[go].

env_cmd(rgo_l(KeyList)) -->
	[rgo],
	sequence_of_terms(KeyList,+).

env_cmd(rgo) -->
	[rgo].

env_cmd(rt) -->
	[rt].

env_cmd(sentences) -->
	[sentences].

env_cmd(parse_compare(I,String)) -->
        [pc],
	[I],
	{ integer(I) },
        sequence_of_terms(String,*).

env_cmd(print_table) -->
	[pt].

env_cmd(parse_compare(String)) -->
        [pc],
        sequence_of_terms(String,*).

env_cmd(generate_compare(Term)) -->
        [gc],
        sequence_of_terms(Term,*).

env_cmd(generate_compare_object(ObjNo)) -->
        [gco],
        [ObjNo],
	{ integer(ObjNo) }.

env_cmd(generate_compare_object(1)) -->
	[gco].

env_cmd(parse(String)) -->
        abbrev(parse,'*'),
        sequence_of_terms(String,*).

env_cmd(translate_obj(generate,Obj)) -->
        abbrev(generate,'-'),
	[ObjNo],
	{ integer(ObjNo),
	  object(ObjNo,Obj)
        }.

env_cmd(gen(Sem)) -->
        abbrev(generate,'-'),
        sequence_of_terms(Sem,*).

env_cmd(translate_obj(generate,Obj)) -->
        abbrev(generate,'-'),
	{ object(1,Obj) }.

env_cmd(compile_grammar) -->
	[lg].

env_cmd(reconsult_grammar) -->
	[rcg].

env_cmd(compile_grammar_files(Files)) -->
	[lg],
	file_list(see,Files,+).

env_cmd(reconsult_grammar_files(Files)) -->
	[rcg],
	file_list(see,Files,+).

env_cmd(show:sh(Type,Output,Thing)) -->
	[w],
	show:type(Type),
	show:output(Output),
	words(Thing).

words([W0|W]) -->
	word(W0),
	words(W).

words([]) --> [].

word(value(Name,lexicon(Words,W,Name))) -->
	[Word],
	{ lexicon(Words,W,Name),
	  ( Word = Name
          ; member(Word,Words)
          ) 
        }.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% FLAG commands %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

env_cmd(available) --> 
	[av].

env_cmd(flag(Att,_,Val)) -->
	flag_att(Att),
	flag_val(Att,Val).

env_cmd(wr_flag(Att,_)) -->
	flag_att(Att).

flag_att(ask) --> 
	abbrev(ask,a).

flag_att(generator) -->
	abbrev(generator,gm).

flag_att(object_saving) --> 
	abbrev(object_saving,os).

flag_att(parser) -->
	abbrev(parser,pm).

flag_att(top_features) -->
	[top].

flag_att(width) -->
	[width].

flag_val(ask,on) -->
        abbrev(on,yes).

flag_val(ask,off) -->
        abbrev(off,no).

flag_val(object_saving,on) -->
        abbrev(on,yes).

flag_val(object_saving,off) -->
        abbrev(off,no).

flag_val(object_saving,semi) -->  % only for object saving..
        [semi].

flag_val(parser,Mode) --> 
	[Mode],
	{user:parser_mode(Mode)}.

flag_val(generator,Mode) --> 
	[Mode],
	{user:generator_mode(Mode)}.

flag_val(width,I) -->
	[I],
	{integer(I)}.

flag_val(top_features,undefined) -->
	['Var'].

flag_val(top_features,undefined) -->
	[undefined].

flag_val(top_features,Name) -->
	[Name],
	{user:top(Name,_)}.

env_cmd(dels_flag(generator_mode,X)) -->
	[no],
	[gm],
	sequence_of_terms(X,+).

env_cmd(adds_flag(generator_mode,X)) -->
	[yes],
	[gm],
	sequence_of_terms(X,+).

env_cmd(only_flag(generator_mode,X)) -->
	[only],
	[gm],
	sequence_of_terms(X,+).

env_cmd(dels_flag(parser_mode,X)) -->
	[no],
	sequence_of_terms(X,+).

env_cmd(adds_flag(parser_mode,X)) -->
	[yes],
	sequence_of_terms(X,+).

env_cmd(only_flag(parser_mode,X)) -->
	[only],
	sequence_of_terms(X,+).

only_flag(M,L):-
	flag(M,_,L),
	user:available.

dels_flag(M,L):-
	( member(P,L),
          del_flag(M,P),
	  add_flag(off(M),P),
          fail
        ; true),
	user:available.

adds_flag(M,L):-
	( member(P,L),
          add_flag(M,P),
	  del_flag(off(M),P),
          fail
        ; true ),
	user:available.

env_cmd(sts(P)) -->
	[sts],
	parser_modes(P,+).

env_cmd(sts) -->
	[sts].

parser_modes([],*) --> 
	[].
parser_modes([H|T],_) -->
	[H],
	{ parser_mode(H) },
	parser_modes(T,_).

:- add_command(env_cmd).


%% modularize it:

user_help(parse,[
'* Sentence         to parse a sentence',nl,
'* ObjSpec          to parse from an object specification']).



user_help(ask,[
'ask OnOff          to set asking on or off']).

user_help(object_saving,[ 
'os OnOff           to set object saving facility on or off']).

user_help(width,[
'width              to show currently defined width of the screen',nl,
'width Integer      redefines width to Integer (used by graphic printing)']).

user_help(type,[          
'type Type          prints the type-tree with root Type']).

user_help(gtype,[         
'gtype Type         graphically prints the type-tree with root Type']).

user_help(top,[           
'top                shows current top category',nl,
'top Name           sets top category to Name',nl,
'                   i.e. top category FS is defined by Name(FS)',nl,
'                   hence Name/1 should be defined']).

user_help(cr,[
'cr                 (re)compiles the rule set',nl]).


user_help(C,[
'pm Parser          to choose parser Parser; ',nl,
'gm Generator       to choose generator Generator; ',nl,
'av                 to obtain list of possible parsers and generators']):-
	member(C,[pm,gm,av]).

user_help(C,M):-
	    user:grammar_writer_help(C,M).



	     












