:- ensure_loaded( compilation ).
:- ensure_loaded( [
	            'PG/rcp3',
		    'PG/approx',
		    'PG/hc',
		    'PG/hc_d',
		    'PG/hc_dtrs',
		    'PG/right_chart',
		    'PG/right_chart_array',
		    'PG/right_chart_pack',
		    'PG/shift_reduce',
		    'PG/bug_dd'
		  ]).

:- initialize_flag(top_features,main).

:- initialize_flag(parser,rcp3).

:- initialize_flag(generator,bug_dd).

:- compile_grammar.

:- version('Grammar based on the paper:
The Scope of Adjuncts and the Processing of Lexical Rules').

:- use_module( library(concat), [ concat/3 ] ).
:- use_module( library(tk) ).

gram_dir(Path) :-
	source_file(gram_dir(_),File),
	concat(Path,'start.pl',File).

gram_startup_hook_begin :-
	update_unary_preds.
gram_startup_hook_end :-
	flag(show_object,_,X^show_object_canvas_tree(q,X)),
	gram_dir(Path),
	concat(Path,'lr.tcl',File),
	concat('source ',File,Cmd),
	tcl_eval(Cmd).


	
:- ensure_loaded(suite).
