:- module(bug_dd,[]).

:- use_module(library(flags)).

:- use_module(library(lists), [ append/3 ]).

:- add_flag(generator_mode,bug_dd).


%%%%%%%%%%%%%%%
%% GENERATOR %%
%%%%%%%%%%%%%%%

clean.
count.
count(0).

% trees are now fully head-corner bottom-up oriented, hence no distinction
% needs to be made for known traversal of given tree or new traversal based
% on semantics!

generate(o(Obj,Str,_)):-
	user:deriv_tree(Obj,Tree),            % supply predicate to convert tree
	bug(Obj,Str,[],Tree0),
	convert_tree(Tree0,Tree).

bug(Node,P0,P,h(Predict,Connect)) :-
	predict_headg(Node,SmallNode,Q0,Q,Predict),
	connectg(SmallNode,Node,Q0,Q,P0,P,Connect).

connectg(X,X,P0,P,P0,P,[]).
connectg(SmallNode,Node,P1,P2,Q0,Q,[rule(Name,Ltrees,Rtrees)|Tree]):-
  	user:h_rule(SmallNode,MidNode,Left,Right,Name),
	bugl(Left,P0,P1,Ltrees),
	bugr(Right,P2,P,Rtrees),
	connectg(MidNode,Node,P0,P,Q0,Q,Tree).

bugr([],P,P,[]).
bugr([H|T],P0,P,[Ht|Tt]) :-
	user:deriv_tree(H,Ht),
	bug(H,P0,P1,Ht),
	bugr(T,P1,P,Tt).

bugl([],P,P,[]).
bugl([H|T],P0,P,[Ht|Tt]) :-
	user:deriv_tree(H,Ht),
	bug(H,P1,P,Ht),
	bugl(T,P0,P1,Tt).

predict_headg(Node,SmallNode,Words,Tail,Rule):-
	user:semantics(Node,Sem),
	user:semantics(SmallNode,Sem),
	user:hfc(SmallNode,Node),
	(  var(Rule) 
        -> user:lexicon(Words0,SmallNode,Rule),
	   user:get_args(SmallNode,Args),
	   bugr(Args,_,_,_)
        ;  user:lexicon(Words0,SmallNode,Rule)
        ),
	append(Words0,Tail,Words).

%% convert_tree(Tree0,Tree).
convert_tree(h(P,C),Tree) :-
	convert_tree(C,tree(P,_,[]),Tree).

convert_tree([],T,T).
convert_tree([rule(H,Ltrees0,Rtrees0)|T],Tree0,Tree) :-
	convert_trees_l(Ltrees0,[Tree0|Rtrees],Trees),   % append implicitly
	convert_trees(Rtrees0,Rtrees),
	convert_tree(T,tree(H,_,Trees),Tree).

% reverse implicitly
convert_trees_l([],L,L).
convert_trees_l([H|T],L0,L) :-
	convert_tree(H,Ht),
	convert_trees_l(T,[Ht|L0],L).

convert_trees([],[]).
convert_trees([H0|T0],[H|T]) :-
	convert_tree(H0,H),
	convert_trees(T0,T).
