:- module(rcp,[]).

:- use_module([ library(database),
		library(flags)
	      ]).
:- use_module( library(wlists), [ wreverse/2 ] ).

:- add_flag(parser_mode,rcp).

% right_chart.pl + packing.

% this is an inactive chart parser with packing.
% The idea is that the items used
% forget about delayed constraints and 
% feature constraints. This makes
% administration of those items cheap, but 
% recovering of parse trees more expensive.
% Items that are asserted are supposedly ground.
% Therefore first phase of the parser is
% context-free technology. During `recovery' features
% and other constraints are applied.
% implode_cat and explode_cat relate complex feature structure with atomic
% category. 

%%% This one does NOT work with a SEPERATE cfg grammar - but forgets about information
%%% present in the rules.

clean :-
	retractall(inactive(_,_,_)),
	retractall(tt(_,_,_,_,_,_)).

parse(o(Node,String,_)) :-
	length(String,Max),
	( bu_lr(0,Max), fail
        ; write('recover parse trees'), nl,
	  ttyflush,
	  apply_semantics(Node,0,Max)).

bu_lr(I,I) :- !, fail.

bu_lr(I0,I):-
	( user:ign_lex(I0,Ix,M,Name),
          store(M,I0,Ix,tree(Name,[],[],[])),
	  fail
        ; I1 is I0 + 1,
	  bu_lr(I1,I)
        ).

% completer(+Cat,+P1,+P,-Edge)
% selects active edge whose rightmost symbol matches Cat
infer(P1,P,Cat):-
	apply_rule(Cat,P1,P,M,P0,P,Tree),
	store(M,P0,P,Tree).   % store in database

% rightmost is not the head
apply_rule(Cat,P3,P,Mother,P0,P,tree(Rule,t(P1,P2,Head),Lds,Rds)) :-
	user:ign_h_rule(Head,Mother,Ls,Rs,Rule),
	wreverse(Rs,[Cat|RestRs]),
	select_lefties(RestRs,P2,P3,[t(P3,P,Cat)],Rds),
	an_inactive(P2,P1,Head),
	select_lefties_nr(Ls,P0,P1,Lds).

% rightmost is the head
apply_rule(Head,P1,P,Mother,P0,P,tree(Rule,t(P1,P,Head),Lds,[])) :-
	user:ign_h_rule(Head,Mother,Ls,[],Rule),
	select_lefties_nr(Ls,P0,P1,Lds).

select_lefties([],P,P,His,His).
select_lefties([H|T],P0,P,HisIn,HisOut):-
	an_inactive(P,P1,H),
	select_lefties(T,P0,P1,[t(P1,P,H)|HisIn],HisOut).

select_lefties_nr([],P,P,[]).
select_lefties_nr([H|T],P0,P,[t(P1,P,H)|HisOut]):-
	an_inactive(P,P1,H),
	select_lefties_nr(T,P0,P1,HisOut).

an_inactive(P,P0,Cat) :-
	inactive(P,P0,Cat0),
	explode_cat(Cat0,Cat).

% store(+M,+P0,+P,+Tree)
store(M0,P0,P,tree(Rule,Head0,Lds0,Rds0)):-
	smallercat(f(M0,Head0,Lds0,Rds0),f(M,Head,Lds,Rds)),
	assert_tt(tt(P0,P,Rule,Head,Lds,Rds),no),
	assert_tt(inactive(P,P0,M),no),
	explode_cat(M,M2),
	infer(P0,P,M2).

assert_tt(Pred,Bool):-
	Pred,!,Bool=yes.
assert_tt(Pred,no) :-
	assertz(Pred).

smallercat(Pred0,Pred) :-
	call_residue(user:copy_term(Pred0,Pred1),_),
	smcat(Pred1,Pred).

smcat(f(M0,Head0,L0,R0),f(M,Head,L,R)) :-
	implode_cat(M0,M),
	smt(Head0,Head),
	smlist(L0,L),
	smlist(R0,R).

smt(t(A,B,C0),t(A,B,C)) :-
	implode_cat(C0,C).
smt([],[]).

smlist([],[]).
smlist([H0|T0],[H|T]) :-
	smt(H0,H),
	smlist(T0,T).

list :-
	listing(inactive/4),
	listing(tt/6).

count :-
	count(D),
	write(D),write(' tt edges'),nl.

count(B) :-
	count_edges(rcp:tt(_,_,_,_,_,_),B).

% apply_semantics(Cat,P0,P,Module)
% builds results on the basis of packed representation,
% using the rules WITH the semantics.
% It is assumed that in Module the predicate tt represents
% the packed forest, such that tt(P0,P,Name,Daughters), where
% P0, P start/end positions, Name is rulename, and Daughters is
% a list of t(P0,P,Cat) triples, or

% Note that unpacking is head-driven!

apply_semantics(Mother,P0,P) :-
	tt(P0,P,Name,[],[],[]),
	user:lex(P0,P,Mother,Name).
apply_semantics(Mother,P0,P):-
	tt(P0,P,Name,t(Q0,Q,Head0),Ls,Rs),
	explode_cat(Head0,Head),
	user:h_rule(Head,Mother,Lds,Rds,Name),
	apply_semantics(Head,Q0,Q),
	apply_ds(Rs,Rds),
	apply_ds(Ls,Lds).

apply_ds([],[]).
apply_ds([t(P0,P,Cat0)|Tail],[Cat|DT]):-
	explode_cat(Cat0,Cat),
	apply_semantics(Cat,P0,P),
	apply_ds(Tail,DT).

% implode_cat(?+Cat,+GroundRestriction)
% explode_cat(+GroundRestriction,?Restriction)

implode_cat(H,Cat) :-
	feature:'<=>'(H:cat,Cat0),
	feature:find_type(Cat0,[Cat|_]).

explode_cat(Cat0,Cat) :-
	feature: '=>'(Cat:cat,Cat0).
