:- module(hc_pack,[]).
:- ensure_loaded(library(flags)).


:- add_flag(parser_mode,hc_pack).

clean :-
	retractall(tt(_,_,_)),
	retractall(tt(_,_,_,_,_,_)),
	retractall(lgoaled(_,_,_)),
	retractall(rgoaled(_,_,_)),
	retractall(result(_,_,_)).

list :-
	listing(lgoaled/3),
	listing(rgoaled/3),
	listing(result/3),
	listing(tt/3),
	listing(tt/6).

count(A,B,C,D,E) :-
	count_edges(hc_pack:tt(_,_,_,_,_,_),A),
	count_edges(hc_pack:tt(_,_,_),B),
	count_edges(hc_pack:lgoaled(_,_,_),C),
	count_edges(hc_pack:rgoaled(_,_,_),D),
	count_edges(hc_pack:result(_,_,_),E).

count(A) :-
	count(A,_B,_C,_D,_E).

count :-
	count(A,B,C,D,E),
	write(A),write(' tt/6 edges'),nl,
	write(B),write(' tt/3 edges'),nl,
	write(C),write(' lgoaled/3 edges'),nl,
	write(D),write(' rgoaled/3 edges'),nl,
	write(E),write(' result edges'),nl.


parse(o(Node,String,_)) :-
	length(String,Max),
	( user:implode_cat(Node,SmNode),
          lparse(SmNode,0,Max,Max), fail
        ; write('recover parse trees'), nl,
	  ttyflush,
	  apply_semantics(Node,0,Max)).

lparse(_,X,X,_) :-
	!,
	fail.

rparse(_,X,X,_) :-
	!,
	fail.

% lparse(+Cat,?P0,?P,+E0,+E)
lparse(Cat,P0,E,P) :-
	lgoal(Cat,P0,E),
	result(Cat,P0,P),
	P =< E.

lgoal(Cat,P0,E) :-
	(    lgoaled(Cat,P0,E)
	->   true
        ;    ( assertz(lgoaled(Cat,P0,E)),
               predict(Cat,P0,E,Small,Q0,Q,TT),
	       connect(Small,Q0,Q,Cat,P0,P,P0,E,[TT]),
	       assertz_if_not(result(Cat,P0,P)),
	       fail
	     ; true )
	).

lgoals([],Q,Q,_,[]).
lgoals([H|T],Q0,Q,E0,[t(Q1,Q,H)|TT]) :-
	rparse(H,E0,Q,Q1),
	lgoals(T,Q0,Q1,E0,TT).

% rparse(+Cat,?P0,?P,+E0,+E)
rparse(Cat,E0,P,P0) :-
	rgoal(Cat,E0,P),
	result(Cat,P0,P),
	E0 =< P0.

rgoal(Cat,E0,P) :-
	(    rgoaled(Cat,E0,P)
	->   true
        ;    assertz(rgoaled(Cat,E0,P)),
             predict(Cat,E0,P,Small,Q0,Q,TT),
	     connect(Small,Q0,Q,Cat,P0,P,E0,P,[TT]),
	     assertz_if_not(result(Cat,P0,P)),
	     fail
	;    true
	).

rgoals([],Q,Q,_,[]).
rgoals([H|T],Q0,Q,E,[t(Q0,Q1,H)|TT]) :-
	lparse(H,Q0,E,Q1),
	rgoals(T,Q1,Q,E,TT).

predict(Cat,E0,E,Cat,Q0,Q,tt(Q0,Q,Name)) :-
	user:cfg_approx_lex(Q0,Q,Cat,Name), 
	E0 =< Q0,
	Q =< E.

connect(Small,Q0,Q,Small,Q0,Q,_,_,TTs) :-
	assertz_if_not_list(TTs).
connect(Small,QL,QR,Cat,P0,P,E0,E,TT) :-
	user:cfg_approx_rule(Small,M,Ls,Rs,Name),
	lgoals(Ls,Q0,QL,E0,Lh),
	rgoals(Rs,QR,Q,E,Rh),
	connect(M,Q0,Q,Cat,P0,P,E0,E,[tt(Q0,Q,Name,t(QL,QR,Cat),Lh,Rh)|TT]).

assertz_if_not(P) :-
	P,!.
assertz_if_not(P) :-
	assertz(P).

assertz_if_not_list([]).
assertz_if_not_list([H|T]) :-
	assertz_if_not(H),
	assertz_if_not_list(T).


% apply_semantics(Cat,P0,P,Module)

% builds results on the basis of packed representation,
% using the rules WITH the semantics (and all other constraints).
% It is assumed that in Module the predicate tt represents
% the packed forest, such that tt(P0,P,Name,Head,Ls,Rs), where
% P0, P start/end positions, Name is rulename, and Ls and Rs is
% a list of t(P0,P,Cat) triples, or tt(P0,P,Name) for daughterless.

% Note that unpacking is head-driven!

apply_semantics(Mother,P0,P) :-
	tt(P0,P,Name),
	user:lex(P0,P,Mother,Name).
apply_semantics(Mother,P0,P):-
	tt(P0,P,Name,t(Q0,Q,Head0),Ls,Rs),
	user:explode_cat(Head0,Head),
	user:h_rule(Head,Mother,Lds,Rds,Name),
	apply_semantics(Head,Q0,Q),
	apply_ds(Rs,Rds),
	apply_ds(Ls,Lds).

apply_ds([],[]).
apply_ds([t(P0,P,Cat0)|Tail],[Cat|DT]):-
	user:explode_cat(Cat0,Cat),
	apply_semantics(Cat,P0,P),
	apply_ds(Tail,DT).

