:- use_module( library(wlists), [ wappend/3 ] ).
:- use_module( library(lists),  [ member/2 ]).


% attempt to use rule names to filter some derivations ..

% implode_cat(?Sign,Atom)
implode_cat(H,Cat/Rule) :-
	H:cat <=> Cat0,
	find_type(Cat0,[Cat|_]),
	rulet(Rule).

% explode_cat(+Atom,Sign).
explode_cat(Cat0/_,Cat) :-
	{ Cat:cat => Cat0 }.

rulet(apply).
rulet(verbfront).
rulet(topicalize).
rulet(extrapose).
rulet(lexical).

cfg_approx_lex(I0,I,M/lexical,Name) :-
	call_residue(ign_lex(I0,I,M0,Name),_),
	implode_cat(M0,M/lexical).

cfg_approx_rule(X/lexical ,X/apply ,Ls,Rs,apply) :-
	dif((Ls,Rs),([],[])),
	largs(Ls,X),
	rargs(Rs,X).

cfg_approx_rule(vp/Head,vp/topicalize,[T],[],topicalize) :-
	topical(T),
	member(Head,[lexical,apply,extrapose,verbfront]).

cfg_approx_rule(vp/Head,vp/extrapose,[],[E],extrapose) :-
	extrapos(E),
	member(Head,[lexical,apply,extrapose]).

cfg_approx_rule(vp/lexical ,vp/lexical,[part/lexical],[],cliticize).

cfg_approx_rule(vp/lexical ,vp/verbfront,[],[Rs0|Rs],verbfront) :-
	wappend(R,L,[Rs0|Rs]),
	largs(L,vp),
	rargs(R,vp).

extrapos(sbar/apply).
extrapos(vp/extrapose).
extrapos(vp/lexical).
extrapos(vp/apply).
extrapos(vp/topicalize).   % relatives
extrapos(pp/apply).

topical(sbar/apply).
topical(vp/extrapose).
topical(vp/lexical).
topical(vp/apply).
topical(np/lexical). 
topical(np/apply).
topical(adj/lexical).
topical(adj/apply).
topical(pred/lexical).
topical(pred/apply).
topical(adv/lexical).
topical(adv/apply).
topical(pp/lexical).
topical(pp/apply).

:- block largs(-,?).
largs([],_).
largs([H|T],X) :-
	larg(X,H),
	largs(T,X).

:- block rargs(-,?).
rargs([],_).
rargs([H|T],X) :-
	rarg(X,H),
	rargs(T,X).

larg(vp,part/lexical ).
larg(vp,vp/H ) :- member(H,[apply,extrapose,lexical]).
larg(vp,np/H ) :- member(H,[apply,lexical]).
larg(vp,adj/H ) :- member(H,[apply,lexical]).
larg(vp,pred/H ) :- member(H,[apply,lexical]).
larg(vp,adv/H ) :- member(H,[apply,lexical]).
larg(vp,pp/H ) :- member(H,[apply]).
larg(n,adj/H ) :- member(H,[apply,lexical]).
larg(n,att/H ) :- member(H,[apply,lexical]).
larg(np,adj/H ) :- member(H,[apply,lexical]).
larg(np,att/H ) :- member(H,[apply,lexical]).
larg(adj,adv/H ) :- member(H,[apply,lexical]).
larg(att,adv/H ) :- member(H,[apply,lexical]).
larg(pred,adv/H ) :- member(H,[apply,lexical]).
larg(adv,adv/H ) :- member(H,[apply,lexical]).

rarg(sbar,vp/H ) :- member(H,[apply,lexical,verbfront,extrapose]).
rarg(vp,sbar/H ) :- member(H,[apply]).
rarg(vp,pp/H ) :- member(H,[apply]).
rarg(vp,vp/H) :- member(H,[apply,lexical,extrapose]).
rarg(n,pp/H ) :- member(H,[apply,lexical]).
rarg(n,vp/H ) :- member(H,[apply,lexical,extrapose,topicalize]).
rarg(n,sbar/H ) :- member(H,[apply]).
rarg(np,n/H ) :- member(H,[apply,lexical]).
rarg(np,pp/H ) :- member(H,[apply,lexical]).
rarg(np,vp/H ) :- member(H,[apply,lexical,topicalize]).
rarg(np,sbar/H ) :- member(H,[apply]).
rarg(pp,np/H ) :- member(H,[apply,lexical]).
rarg(adj,pp/H ) :- member(H,[apply,lexical]).
rarg(adj,sbar/H ) :- member(H,[apply]).
rarg(att,pp/H ) :- member(H,[apply,lexical]).
rarg(att,sbar/H ) :- member(H,[lexical]).






























































