:- compile(ops).

:- prolog_flag(redefine_warnings,Old,off),
   ensure_loaded(ubg_utils),     % defines unification macros's
   ensure_loaded(declarations),  % needed by TkHdrug
   prolog_flag(redefine_warnings,_,Old).

:- ensure_loaded(lexicon).       %
:- ensure_loaded(parser).        %
:- ensure_loaded(shift_reduce).  %
:- ensure_loaded(interface).     % 



compile_grammar :-
	compile_grammar_file(cug).

reconsut_grammar :-
	reconsult_grammar_file(cug).

compile_grammar_file(File) :-
	ensure_loaded(File),
	compile_lexicon,
	compile_rules.

reconsult_grammar_file(File) :-
	reconsult(File),
	compile_lexicon,
	compile_rules.

:- compile_grammar.


:- initialize_flag(top_features,s).

:- initialize_flag(parser,parser).

:- version('Grammar by Gosse Bouma, cf. Bouma and van Noord, 
"Constraint-based Categorial Grammar" ACL 1994').

gram_dir(Path) :-
	source_file(gram_dir(_),File),
	concat(Path,'start.pl',File).

gram_startup_hook_end :-
	gram_dir(Path),
	concat(Path,'cbcg.tcl',File),
	concat('source ',File,Cmd),
	tcl_eval(Cmd).

send_gossebm :-
	gram_dir(Path),
	concat(Path,'gosse.bm',File),
	concat('set gossebm ',File,Cmd),
	tcl_eval(Cmd).

:- ensure_loaded(suite).
