:- use_module( library(decons),  [ prolog_conjunction/2 ]).
:- use_module( library(concat)).

top(s,t(X,_)) :-
	X <=> s,
	X <=> vsecond,
	X:gap <=> empty.

top(q,t(X,_)) :-
	X <=> s,
	X <=> vfirst,
	X:gap <=> empty.


% re-defines default one, handle lexicon lookup locally
start_parse_hook(_,_).


% EXTERN_SEM/2
% extern_sem(ExtSem,IntSem)
%
% is like a reversible `portray' of semantics 
%
% ExtSem should be a list of prolog terms
% it is read in using `sequence_of_terms' => command.pl
% and written using `write_list3' => message.pl
%

extern_sem([S],S).

%
% for phonology this is built in:
% extern: a sequence of atoms
% intern: a list of index:atom pairs
% think of extern_phon to be defined as for exmaple:
%   extern_phon([jan,kust,marie],[1:jan,2:kust,3:marie]).
%
%

% PHONOLOGY/2
% phonology(-Node,+Phon)
% phonology(+Node,?Phon
% defines the phonology Phon of node Node
%
% is only neccesary if you do generation, or if your
% grammar is sign-based, and you want the string attribute
% of the top-goal to be instantiated. Note that phonology
% is called _before_ parser starts as well, hence don't
% define it as `yield'
%
% is used to 
% 1. print result of generation
% 2. instantiate phon attribute during parsing (in case of
%    sign-based grammar)
%

phonology(_,_).

% SEMANTICS/2
% semantics(Node,Sem)
% defines the semantics Sem of node Node. Is used: 
% 
% 1. in order to determine the semantic-head of a rule 
%    (for head-driven generation).
% 2. to instantiate the semantics of a node, at the
%    start of generation. 
% 3. to print the result of parsing.

semantics(t(Sign,_),Sem) :-
	Sign:sem <=> Sem.


user_clause(rule(A,B,C,D),Body) :-
	call_residue(rule(A,B,C,D),Cons),
	rewrite_body(Cons,[],Body,[]).

user_clause(Head,Body) :-
	clause(lex(A,B),Body0),
	(   atomic(A) 
        ->  Head =.. [A,B]
        ;   A = [te,X],
	    concat('te_',X,F),
	    Head =.. [F,B]
	),
	prolog_conjunction(Body0,Body).

