:- op(500,xfy,\).
:- op(600, xfx, <=> ).


%%%%%%%%%%%%%%%%%%%%% Feature Unification %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% Calder's feature unification 
%%%% Modified, so that (term-) unification takes place after the cut.
%%%% Needed to ensure all solutions of nondeterministic blocked goals.
 
fvt_unify(A,B) :- var(A), !, A = B.
fvt_unify(A,B) :- var(B), !, A = B.
fvt_unify(fvt(Feature,Value,Tail),fvt(F,V,T)) :- !,
          fvt_feature_value(Feature,fvt(F,V,T),Value,Tail1),
          fvt_unify(Tail,Tail1).
fvt_unify(A,A).			% other prolog terms

fvt_feature_value(Feature, fvt(Feature, Value, Rest), V, Rest) :- !,
    fvt_unify(Value, V).
fvt_feature_value(X, fvt(Feature, V, Tail), Value, fvt(Feature, V, Rest)) :-
    fvt_feature_value(X, Tail, Value, Rest).

%%%% fvt unification macros

X <=> Y:- 
	denotes(X, Xfvt), 
	denotes(Y, Yfvt), 
	fvt_unify(Xfvt,Yfvt).

denotes(Var, FVT) :- 
	var(Var), !, 
	Var = FVT.
denotes(A/B,fvt(val,Val,fvt(dir,right,fvt(arg,Arg,fvt(cat,nil,_))))) :-
        !,
        denotes(A,Val),
        denotes(B,Arg).
denotes(B\A,fvt(val,Val,fvt(dir,left,fvt(arg,Arg,fvt(cat,nil,_))))) :-
        !,
        denotes(A,Val),
        denotes(B,Arg).
denotes(Dag:Path, Value):-
        !, 
        pathval(Dag, Path, Value).
denotes(fvt(F,V,T),fvt(F,V,T)) :- 
	!.        
denotes(Term,FVT) :- 
	temp(Term,FVT).
denotes(Any, Any) :- 
	\+ temp(Any,_).
	
pathval(Dag,Feat:Path, Value) :- !,
        fvt_unify(Dag,fvt(Feat,Dag1,_)),
        pathval(Dag1,Path,Value).
pathval(Dag,Feat,Dag1) :-
        fvt_unify(Dag,fvt(Feat,Dag1,_)).

%%%%%%%%%%%%%%%%%%%%%%%%%% defaulty stuff %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

unify_except(FVT1,FVT2,[]) :-		% unify FVT1 and FVT2 except for 
	FVT1 <=> FVT2.			% features in List
unify_except(FVT1,FVT2,[F|R]) :-	% (should use default unification)
	FVT1 <=> fvt(F,_,Tail1),
	FVT2 <=> fvt(F,_,Tail2),
	unify_except(Tail1,Tail2,R).
	
%%% lexical defaults 

apply_default(Default) :-		
	( call(Default), !
	; true
	).

	
