/*  PRETTY.PL  */


%
% From: psmielke@lotus.waterloo.edu (Peter Mielke)
% Thanks, Pete!
%
% print a structure tree
%
% eg.  print_struct(a(b,c,d(e,f))) gives:
%
% a(
%     b,
%     c,
%     d(
%         e,
%         f
%     )
% )
%
print_struct(Tree) :-
    Tree =.. List,
    p_struct(0,List), nl.

%
% the first element of the list is the name of the "functor"
% from the =.. command
%
p_struct(_,[]).
p_struct(Num,[Head|List]) :-
    is_sarg(List), !,
    nl, tab(Num), write( Head), put(40), % left bracket
    put(32), get_head(Element,List),write(Element), put(32), put(41).
p_struct(Num,[Head|List]) :-
    nl, tab(Num), write( Head ), put(40), % left bracket
    Num2 is Num + 4,
    p_list(Num2,List).

%
% a lousy way to see if the function only has a single arguement
%
is_sarg([]).
is_sarg([Head|Tail]) :-
    Tail = [],
    atom( Head ).

%
% an even lousier way of getting an element out of a single list (i.e. [a] )
%
get_head( Head, [Head|_]).

%
% prints out the list of terms for a "functor"
%
p_list(_,[]) :-
    put(41). % finishing right bracket
p_list(Num,[Head|List]) :-
    atom(Head), !,
    nl, tab(Num), write( Head ), p_comma(List),
    p_list(Num,List).
p_list(Num,[Head|List]) :-
    Head =.. Sublist,
    p_struct(Num,Sublist),
    p_comma(List),
    p_list(Num,List).

%
% print a comma only if we are NOT at the end of the list
%
p_comma([]).
p_comma(_) :-
    put(44).
