
(defparameter *ugrammar*
  '((avsgl --> init statements
           #'(lambda (i s)
               (unless *start-cat*
                 (format t "~%Warning: The start category has not been defined")
                 (format t "~% (Set to an uninstantiated category)")
                 (setq *start-cat* (make-avnode)))
               (unless *restrictor-cat*
                 (format t "~%Warning:  The restrictor has not been defined")
                 (format t "~% (Set to an uninstantiated category, ie. bottom-up)")
                 (setq *restrictor-cat* (make-avnode)))
               (list *rules* *lexical-entries* *start-cat* *restrictor-cat*)))
    (init -->
          #'(lambda ()
              (setq *rules* '())
              (setq *lexical-entries* '())
              (setq *start-cat* nil)
              (setq *restrictor-cat* nil)
              (setq *vars* '())
              (setq *val-prefix* 'val)
              (setq *cat-prefix* 'cat)))
    (statements -->
                #'nullfn)
    (statements --> statements statement period
                #'nullfn)
    (statement --> vars
               #'nullfn)
    (statement --> start-cat
               #'nullfn)
    (statement --> cat-prefix
               #'nullfn)
    (statement --> val-prefix
               #'nullfn)
    (statement --> restrict
               #'nullfn)
    (statement --> lexical-entry
               #'nullfn)
    (statement --> rule
               #'nullfn)
    (vars --> variables equal symbol-list
               #'(lambda (v e vars)
                   (setq *vars* vars)))
    (start-cat --> start-category colon equal cat
               #'(lambda (s co e cat)
                   (when *start-cat*
                     (format t "~%Warning:  Resetting start category"))
                   (setq *start-cat* cat)))
    (cat-prefix --> category-prefix equal symbol-or-nil
                #'(lambda (cp c symbol)
                    (setq *cat-prefix* symbol)))
    (val-prefix --> value-prefix equal symbol-or-nil
                #'(lambda (vp c symbol)
                    (setq *val-prefix* symbol)))
    (symbol-or-nil --> symbol
                   #'identity)
    (symbol-or-nil -->
                   #'nullfn)
    (restrict --> restrictor colon equal cat
                #'(lambda (r co e cat)
                    (when *restrictor-cat*
                      (format t "~%Warning:  Resetting restrictor category"))
                    (setq *restrictor-cat* cat)))
    (lexical-entry --> lex-form lex-cat colon cat
                   #'(lambda (lf lex-cat c cat)
                       (let ((entry (assoc lf *lexical-entries*)))
                         (if entry
                           (push cat (cdr entry))
                           (push (list lf cat)    ; because LoadWords expects a list of categories!
                                 *lexical-entries*)))))
    (lex-form --> symbol
                #'(lambda (s)
                    (setq *current-form* `(|lexical entry| ,s))
                    s))
    (lex-cat -->
             #'nullfn)
    (lex-cat --> symbol
             #'(lambda (lex-cat)
                 (unify-avs (make-att-val (make-att-val *u-env* 'root)
                                          *cat-prefix*) lex-cat)))
    (rule --> rule-cats colon eqns
          #'(lambda (ndaughters colon eqns)
              (Reset-Copier)
              (push (make-rule :mother (copy-avs (make-att-val *u-env* -1))
                               :daughters (let (result)
                                            (dotimes (i ndaughters)
                                              (push (copy-avs (make-att-val *u-env* i)) result))
                                            (nreverse result)))
                    *rules*)
              (New-Generation)))
    (rule-cats --> symbol-or-underline --> symbol-list
               #'(lambda (mother a daughters)
                   (setq *current-form* `(|syntactic rule| ,mother --> ,@daughters))
                   (when *cat-prefix*
                     (unless (eq mother 'underline)
                       (unify-avs (make-att-val (make-att-val *u-env* -1) *cat-prefix*) 
                                  mother))
                     (dotimes (i (length daughters))
                       (unless (eq (nth i daughters) 'underline)
                         (unify-avs (make-att-val (make-att-val *u-env* i) *cat-prefix*)
                                    (nth i daughters)))))
                   (length daughters)))
    (symbol-list -->
                 #'nullfn)
    (symbol-list --> symbol symbol-list
                 #'cons)
    (symbol-list --> underline symbol-list
                 #'(lambda (u ss)
                     (cons 'underline ss)))
    (symbol-or-underline --> symbol
                         #'identity)
    (symbol-or-underline --> underline
                         #'(lambda (u) 'underline))
    (cat -->                  ;; the empty set of equations
         #'(lambda ()
             (make-avnode)))
    (cat --> eqns
         #'(lambda (e)
             (Reset-Copier)
             (let ((value (copy-avs (make-att-val *u-env* 'root))))
               (New-Generation)
               value)))
    (eqns --> eqns comma eqn
          #'nullfn)
    (eqns --> eqn
          #'nullfn)
    (eqn --> path equal path
         #'(lambda (p1 e p2)
             (if (null (unify-avs p1 p2))
               (format t "~%Warning: Failed unification in ~{~a ~}" *current-form*))))
    (path --> symbol left-parenthesis path right-parenthesis
          #'(lambda (symbol left path right)
              (make-att-val path symbol)))
    (path --> symbol
          #'(lambda (s)
              (if (member s *vars*)
                (make-att-val *u-env* s)
                s)))
    (path --> star
          #'(lambda (s)
              (if *val-prefix*
                (make-att-val (make-att-val *u-env* 'root) *val-prefix*)
                (make-att-val *u-env* 'root))))
    (path --> star star
          #'(lambda (s1 s2)
              (make-att-val *u-env* 'root)))
    (path --> underline
          #'(lambda (u)
              (make-avnode)))
    (path --> star symbol
          #'(lambda (s sym)
              (if (integerp sym)
                (if *val-prefix*
                  (make-att-val (make-att-val *u-env* (1- sym)) *val-prefix*)
                  (make-att-val *u-env* (1- sym)))
                (format t "~%Illegal use of *~a in ~{~a ~}" sym *current-form*))))
    ))

; (eval (Lalr:Make-Parser *ugrammar* *ulexforms* '|#]|))
