
; ----------------------------  wd_tsks.s  ---------------------------------

;>>>>> 
;>>>>> word tasks
;>>>>> 

;> updates and loads each word
(define (word-tasks)
  (set! *prev-w* *curr-w*)
  (set! *curr-w* (pop *s*))
  (set! *next-w* (kar *s*))
  (cond ((null? *curr-w*) (set! *go-on* nil) nil)
	(else (run-word *curr-w*))))

;> runs word if it has been defined
(define (run-word word)
  (out ^p 0 "-------------------------- ~%")
  (out ^p 0 "Processing word ~a ~%" word)
  (out ^p 0 "-------------------------- ~%")
  (if (get word 'word)	;> if "word" is a word, 
      (load-word word)	;> then load word definition
      (out ^p 1 "--- ignored")))

;>>>>>
;>>>>> declarative notation for word senses
;>>>>>

;> load the word into working memory and spawn any associated demons
(define (load-word word)
  (let ((con (generate-symbol 'con))
	(def (get word 'def))
	(dem (get word 'demons)))
       (if def 			;--> if there is an unambiguous definition
	   (set-top-level-value! con (split-config con def))
	   (set-top-level-value! con nil))
       (add-wm con)
       (out ^p 3 "~a = ~a~%" con (eval con))
       (if dem 			;--> if there are demons spawn them
	   (spawn-dforms con dem nil))))

;> place a con the front of the WM queue, setting the BEFore and AFTer pointers
(define (add-wm con)
  (out ^p 1 "Adding to *wm*: ~a~%" con)
  (put con 'word *curr-w*)
  (cond ((null? *wm*) (set! *wm* con))	;--> if this is the first word, 
	(else (put con 'bef *wm*)	;	initialize *wm*
	      (put *wm* 'aft con)
	      (set! *wm* con))))

;> a word definition in the lexicon should be in configuration form.
;>   a configuration is a CD structure with any gap-filling demons
;>   associated with it
;> 	config   => nil ^ (pred) ^ (pred slot-name spec ... slot-name spec)
;> 	spec     => config ^ gap-atom [ <== (dform ... dform) ]
;> 	gap-atom => atom ^ *

;> separates demons from config and returns the appropriate structure with
;>   gap-atoms created
(define (split-config con config)
  (out ^bob 0 "<<< split-config ~a~%" config)
  (if config
      (cons (kar config) (split-rest con (kdr config)))))

;>>> Note:  the following four items are written as macros since the dynamic
;>>>		scoping in TLisp (the original language in which McDypar was
;>>>		written) screws everything up in scheme (lexical scoping).

;> if the gap position is nil, then create a gap-node with the value nil
(extend-syntax (empty-gap)
  ((empty-gap)
   (begin (set! gap (apply generate-symbol (list slot)))
	  (out ^bob 0 "<<< empty-gap ~a~%" gap)
	  (set-top-level-value! gap nil))))

;> if the gap position holds an embedded structure, then recursively spawn
;>   any demons for that structure
(extend-syntax (config-gap)
  ((config-gap)
   (begin (set! gap (apply generate-symbol (list slot)))
	  (out ^bob 0 "<<< config-gap ~a~%" gap)
	  (set-top-level-value! gap (split-config con filler)))))

;> if the gap position holds a "*" then spawn the demons following "<=="
(extend-syntax (*-gap)
  ((*-gap)
   (begin (set! gap (apply generate-symbol (list slot)))
	  (out ^bob 0 "<<< *-gap ~a~%" gap)
	  (set-top-level-value! gap nil)
	  (pop rest)  			;--> remove "<=="
	  (set! dforms (pop rest))
	  (spawn-dforms con dforms gap))))

;> if the gap position holds an atom then it may or may not be followed by
;>   demons; if demons do follow it, then save the atom so that other
;>   references to it get the same gap
(extend-syntax (atm-gap)
  ((atm-gap)
   (cond ((eq? (kar rest) '<==)		;--> is followed by demons
	  (set! gap (apply generate-symbol (list slot)))
	  (out ^bob 0 "<<< atm-gap ~a~%" gap)
	  (set-top-level-value! gap nil)
	  (push *gap-alist* (cons filler gap))
	  (pop rest)  			;--> remove " <== "
	  (set! dforms (pop rest))
	  (spawn-dforms con dforms gap))
	 (else 
	  (set! gap (kdr (assq filler *gap-alist*)))
	  (out ^bob 0 "<<< atm-gap ~a~%" gap)
	  (or gap 
	      (set-top-level-value! gap filler))))))

;> takes a list of form (slot filler ... slot filler), where each filler may
;>   be followed by <== (dform) and returns a singly atomized structure
(define (split-rest con rest)
  (let
   ((struc nil)
    (slot nil)
    (filler nil)
    (gap nil)
    (dforms nil))
   (define (loop) 
	   (cond 
	    ((null? rest) struc)
	    (else
	     (set! slot (pop rest))
	     (set! filler (pop rest))
	     (out ^bob 0 "<<< split-rest ~a : ~a~%" slot filler)
	     (set! struc (append1 struc slot))
	     (cond ((null? filler) (empty-gap))
		   ((pair? filler) (config-gap))
		   ((eq? '* filler) (*-gap))
		   ((atom? filler) (atm-gap)))
	     (set! struc (append1 struc gap))
	     (loop))))
   (loop)))

