
;-------------------------------- exec_dms.s -----------------------------
;>>>
;>>> demon management
;>>>

;> go through each con in working memory and test all demons associated with
;>   each;  if a demon fires, then go back and test them again
(define (demon-tasks)
  (set! *demon-fired* t)
  (letrec ((loop
	    (lambda ()
		    (cond (*demon-fired* 
			   (set! *demon-fired* nil)
			   (examine-all-d-agendas *wm*)
			   (out ^bob 0 "<<< demon-tasks ~a~%" *demon-fired*)
			   (loop))
			  (else nil)))))
	  (loop)))

(define (examine-all-d-agendas con)
  (letrec ((loop
	    (lambda (con)
		    (cond (con
			   (walk (lambda (d-atm) 
					 (set! *curr-demon* d-atm)
					 (run-demon-atm d-atm con))
				 (get con 'd-agenda))
			   (loop (get con 'bef)))
			  (else nil)))))
	  (loop con)))

;>>>
;>>> demon interpreter functions
;>>>

;> Note: variables that the Killpart wants to pass to the Testpart
;> 	   or that the Testpart wants to pass to the Actpart, etc.
;>	   should be marked SHARE and then just SET (globally, i think)
;>
;> Note: an empty test part is equivalent to (test t)
;>
(define (run-demon-atm d-atm con)
  (out ^bob 0 "<<< run-demon-atm d-atm ~a con ~a~%" d-atm con)
  (let* ((d-form (eval d-atm))
	 (d-name (kar d-form))
	 (argums (kdr d-form))
	 (d-body nil))
	(set! d-body (get d-name 'demon))
	(param-environ d-name d-body argums d-atm con)))

;> set! demon parameters and variables in the demon environment
(define (set-demon-vars! params argums)
  (if (null? params) nil
      (cond ((null? argums)
	     (demon-set-value! (kar params) '() )
	     (set-demon-vars! (kdr params) '() ))
	    (else
	     (demon-set-value! (kar params) (kar argums))
	     (set-demon-vars! (kdr params) (kdr argums))))))

;> set! up parameter/shared variable environment:
;>    once params have been bound with values from argums, 
;>    set! up shared variables and initialize them to ();
(define (param-environ d-name d-body argums d-atm con)
  (out ^bob 0 "<<< param-environ d-name ~a argums ~a~%" d-name argums)
  (let ((prms       (kdr (assq 'params d-body)))
	(share-vars (kdr (assq 'share  d-body))))
    (set! demon-env (make-env (append prms share-vars '(test))))
    (if argums 	(set-demon-vars! prms argums)))
  (run-demon d-name d-body d-atm con))

;> return the new environment object to be used as the new demon environment
(define (make-env params)
  (define (list-of-nulls num)
    (if (= num 0) 
        nil
        (cons nil (list-of-nulls (-1+ num)))))
  (eval (cons (eval (list 'lambda params '(the-environment)))
              (list-of-nulls (length params)))))

;> interpret demon keyword-parts
(define (run-demon d-name d-body d-atm con)
  (out ^bob 0 "<<< run-demon d-name ~a~%" d-name)
  (demon-set-value! 'test nil)
  (let ((kill-part (assq 'kill d-body))
	(test-part (assq 'test d-body))
	(+act-part (assq '+act d-body))
	(-act-part (assq '-act d-body)))
       (out ^bob 3 "kill ~a~%" kill-part)
       (out ^bob 3 "test ~a~%" test-part)
       (out ^bob 3 "+act ~a~%" +act-part)
       (out ^bob 3 "-act ~a~%" -act-part) 
       (cond 
	;--> if kill-part exists and evaluates (in the demon environment)
	;-->     to #t, then kill demon
	((and kill-part 
	      (demon-eval (cons 'begin (kdr kill-part))))
	 (out ^bob 0 "<<< run-demon kill-part ~a~%" con)
	 (kill-demon d-atm con))
	((or (null? test-part) 
	     ;--> so act-parts can refer to the result of test-part
	     (demon-set-value! 'test (demon-eval (cons 'begin 
						       (kdr test-part)))))
	 (out ^bob 0 "<<<test ~a~%" (access test demon-env))
	 (out ^p 1 "Executing: ~a = ~a~%" d-atm (eval d-atm))
	 (demon-eval (cons 'begin (kdr +act-part)))
	 (kill-demon d-atm con))
	((and -act-part (null? (access test demon-env)))
	 (out ^p 1 "Executing -act of ~a = ~a~%" d-atm (eval d-atm))
	 (demon-eval (cons 'begin (kdr -act-part)))
	 (kill-demon d-atm con)))))

(define (kill-demon d-atm con)
  (out ^p 1 "Killing: ~a = ~a~%" d-atm (eval d-atm))
  (let ((dforms (get con 'd-agenda)))
       (set! dforms (remove1st d-atm dforms))	;--> remove the demon
       (set! *demon-fired* t)			;--> go through demons again
       (put con 'd-agenda dforms)))


